/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.resource;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.PageTemplate;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Template;
import java.io.File;

public class ResourceRenderer
extends io.intino.konos.builder.codegeneration.ui.resource.ResourceRenderer {
    public ResourceRenderer(Settings settings, Service.UI.Resource resource) {
        super(settings, resource, Target.Accessor);
    }

    @Override
    public void render() {
        this.writeHtml(this.buildFrame());
        this.writeJavascript(this.buildFrame());
    }

    private void writeHtml(FrameBuilder builder) {
        builder.add("html");
        File file = new File(this.src() + File.separator + this.resource.name$() + ".html");
        if (file.exists()) {
            return;
        }
        Commons.write(file.toPath(), this.setup(new PageTemplate()).render((Object)builder.toFrame()));
    }

    private void writeJavascript(FrameBuilder builder) {
        builder.add("js");
        File destiny = CodeGenerationHelper.createIfNotExists(new File(this.gen() + File.separator + "pages" + File.separator));
        File file = new File(destiny + File.separator + Commons.firstUpperCase(this.resource.name$()) + ".js");
        Commons.write(file.toPath(), this.setup(new PageTemplate()).render((Object)builder.toFrame()));
    }

    @Override
    public FrameBuilder buildFrame() {
        FrameBuilder result = super.buildFrame().add("resource");
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        result.add("name", (Object)this.resource.name$());
        Template template = KonosGraph.templateFor(this.resource);
        result.add("pageDisplay", (Object)template.name$());
        result.add("pageDisplayId", (Object)this.shortId(template));
        result.add("pageDisplayType", (Object)this.typeOf(template));
        uiService.useList().forEach(use -> result.add("accessibleImport", (Object)this.accessibleImportFrame((Service.UI.Use)((Object)use))));
        this.addPageDisplayOrigin(result, template);
        return result;
    }

    private void addPageDisplayOrigin(FrameBuilder builder, Display display) {
        FrameBuilder originFrame = new FrameBuilder();
        if (ElementHelper.isRoot(display)) {
            originFrame.add("decorated", (Object)"");
        }
        builder.add("pageDisplayOrigin", (Object)originFrame);
    }

    private Frame accessibleImportFrame(Service.UI.Use use) {
        FrameBuilder result = new FrameBuilder(new String[]{"accessibleImport"});
        result.add("name", (Object)use.name$());
        result.add("url", (Object)use.url());
        result.add("elements", (Object)StringHelper.camelCaseToSnakeCase((String)use.className().substring(use.className().lastIndexOf(".") + 1)));
        return result.toFrame();
    }
}

