/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.openapi.module.Module;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.actions.IntinoTestTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import io.intino.tara.magritte.Layer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class IntinoTestRenderer {
    private KonosGraph graph;
    private PsiDirectory directory;
    private String newName;

    IntinoTestRenderer(Module module, PsiDirectory directory, String newName) {
        this.directory = directory;
        this.newName = newName;
        this.graph = new GraphLoader().loadGraph(module);
    }

    public String execute() {
        if (this.graph == null) {
            return null;
        }
        FrameBuilder builder = new FrameBuilder();
        builder.add("intinoTest").add("package", (Object)this.calculatePackage()).add("name", (Object)this.newName);
        this.addRESTServices(builder);
        this.addMessagingServices(builder);
        this.addSlackServices(builder);
        this.addUIServices(builder);
        return this.template().render((Object)builder);
    }

    private String calculatePackage() {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(this.directory);
        return aPackage == null ? "" : aPackage.getQualifiedName();
    }

    private void addRESTServices(FrameBuilder builder) {
        this.graph.serviceList(Service::isREST).map(Service::asREST).forEach(service -> {
            FrameBuilder restBuilder = new FrameBuilder(new String[]{"service"}).add("rest").add("name", (Object)service.name$());
            this.addUserVariables(service.a$(Service.class), restBuilder, this.findCustomParameters((Service.REST)((Object)service)));
            builder.add("service", (Object)restBuilder.toFrame());
        });
    }

    private void addMessagingServices(FrameBuilder builder) {
        this.graph.serviceList(Service::isMessaging).map(Service::asMessaging).forEach(service -> {
            FrameBuilder jmsBuilder = new FrameBuilder(new String[]{"service"}).add("jms").add("name", (Object)service.name$());
            this.addUserVariables(service.a$(Service.class), jmsBuilder, this.findCustomParameters((Service.Messaging)((Object)service)));
            builder.add("service", (Object)jmsBuilder.toFrame());
        });
    }

    private void addUIServices(FrameBuilder builder) {
        this.graph.serviceList(Service::isUI).map(Service::asUI).forEach(service -> {
            FrameBuilder serviceBuilder = new FrameBuilder(new String[]{"service"}).add("ui").add("name", (Object)service.name$());
            builder.add("service", (Object)serviceBuilder);
            if (service.authentication() != null) {
                serviceBuilder.add("auth");
                serviceBuilder.add("auth", (Object)service.authentication().by());
            }
            this.addUserVariables((Layer)service, serviceBuilder, (Collection<String>)this.findCustomParameters((Service.UI)((Object)service)));
        });
    }

    private void addSlackServices(FrameBuilder builder) {
        this.graph.serviceList(Service::isSlackBot).map(Service::asSlackBot).forEach(s -> builder.add("service", (Object)new FrameBuilder(new String[]{"service"}).add("slack").add("name", (Object)s.name$())));
    }

    private void addUserVariables(Layer layer, FrameBuilder builder, Collection<String> userVariables) {
        for (String custom : userVariables) {
            builder.add("custom", (Object)new FrameBuilder(new String[]{"custom"}).add("conf", (Object)layer.name$()).add("name", (Object)custom).add("type", (Object)"String"));
        }
    }

    private Set<String> findCustomParameters(Service.Messaging service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Service.Messaging.Request request : service.requestList()) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(Service.REST service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Service.REST.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(Service.UI service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (service.authentication() != null) {
            set.addAll(Commons.extractParameters(service.authentication().by()));
        }
        for (Service.UI.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private Template template() {
        return Formatters.customize(new IntinoTestTemplate());
    }
}

