/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.accessible.AccessibleDisplay;
import io.intino.konos.model.graph.decorated.DecoratedDisplay;
import io.intino.konos.model.graph.extensionof.ExtensionOfPassiveView;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Display
extends PassiveView
implements Terminal {
    protected List<Component> components = new ArrayList<Component>();
    protected String parentDisplay;
    protected List<Block> blockList = new ArrayList<Block>();

    public Display(Node node) {
        super(node);
    }

    public List<Component> components() {
        return this.components;
    }

    public Component components(int index) {
        return this.components.get(index);
    }

    public List<Component> components(Predicate<Component> predicate) {
        return this.components().stream().filter(predicate).collect(Collectors.toList());
    }

    public String parentDisplay() {
        return this.parentDisplay;
    }

    public Display parentDisplay(String value) {
        this.parentDisplay = value;
        return this;
    }

    public List<Block> blockList() {
        return Collections.unmodifiableList(this.blockList);
    }

    public Block block(int index) {
        return this.blockList.get(index);
    }

    public List<Block> blockList(Predicate<Block> predicate) {
        return this.blockList().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public ExtensionOfPassiveView asExtensionOf() {
        return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
    }

    @Override
    public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
        ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
        newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
        return newElement;
    }

    @Override
    public boolean isExtensionOf() {
        return this.core$().is(ExtensionOfPassiveView.class);
    }

    @Override
    public void removeExtensionOf() {
        this.core$().removeFacet(ExtensionOfPassiveView.class);
    }

    public DecoratedDisplay asDecorated() {
        Layer as = this.a$(DecoratedDisplay.class);
        return as != null ? (DecoratedDisplay)as : (DecoratedDisplay)this.core$().addFacet(DecoratedDisplay.class);
    }

    public boolean isDecorated() {
        return this.core$().is(DecoratedDisplay.class);
    }

    public AccessibleDisplay asAccessible() {
        return (AccessibleDisplay)this.a$(AccessibleDisplay.class);
    }

    public AccessibleDisplay asAccessible(List<String> parameters) {
        AccessibleDisplay newElement = (AccessibleDisplay)this.core$().addFacet(AccessibleDisplay.class);
        newElement.core$().set((Layer)newElement, "parameters", parameters);
        return newElement;
    }

    public boolean isAccessible() {
        return this.core$().is(AccessibleDisplay.class);
    }

    public void removeAccessible() {
        this.core$().removeFacet(AccessibleDisplay.class);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Block>(this.blockList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("components", this.components);
        map.put("parentDisplay", new ArrayList<String>(Collections.singletonList(this.parentDisplay)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Block")) {
            this.blockList.add((Block)node.as(Block.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Block")) {
            this.blockList.remove(node.as(Block.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("components")) {
            this.components = NodeLoader.load(values, Component.class, (Layer)this);
        } else if (name.equalsIgnoreCase("parentDisplay")) {
            this.parentDisplay = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("components")) {
            this.components = values.stream().map(s -> (Component)this.graph().core$().load(((Layer)s).core$().id()).as(Component.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("parentDisplay")) {
            this.parentDisplay = (String)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear
    extends PassiveView.Clear {
        public void block(Predicate<Block> filter) {
            new ArrayList<Block>(Display.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends PassiveView.Create {
        public Create(String name) {
            super(name);
        }

        public Block block() {
            Block newElement = (Block)Display.this.core$().graph().concept(Block.class).createNode(this.name, Display.this.core$()).as(Block.class);
            return newElement;
        }
    }
}

