/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.helpers;

import com.intellij.openapi.diagnostic.Logger;
import io.intino.konos.model.graph.Redirect;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.rest.RESTService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Commons {
    private static final Logger LOG = Logger.getInstance((String)"Konos: ");

    public static void writeFrame(File packageFolder, String name, String text) {
        try {
            packageFolder.mkdirs();
            File file = Commons.javaFile(packageFolder, name);
            Files.write(file.toPath(), text.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void write(File file, String text) {
        Commons.write(file.toPath(), text);
    }

    public static void write(Path file, String text) {
        try {
            Files.write(file, text.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static File javaFile(File packageFolder, String name) {
        return Commons.preparedFile(packageFolder, name, "java");
    }

    public static String javaFilename(String name) {
        return Commons.prepareName(name) + ".java";
    }

    public static File javascriptFile(File packageFolder, String name) {
        return Commons.preparedFile(packageFolder, name, "js");
    }

    public static long queryParameters(RESTService.Resource.Operation operation) {
        return operation.parameterList().stream().filter(p -> p.in() == RESTService.Resource.Parameter.In.query).count();
    }

    public static long bodyParameters(RESTService.Resource.Operation operation) {
        return operation.parameterList().stream().filter(p -> p.in() == RESTService.Resource.Parameter.In.body).count();
    }

    public static long queryParameters(RESTService.Notification operation) {
        return operation.parameterList().stream().filter(p -> p.in() == RESTService.Notification.Parameter.In.query).count();
    }

    public static long bodyParameters(RESTService.Notification operation) {
        return operation.parameterList().stream().filter(p -> p.in() == RESTService.Notification.Parameter.In.body).count();
    }

    public static String format(String path) {
        return path.isEmpty() ? "" : path + "/";
    }

    public static String path(RESTService.Resource resource) {
        RESTService service = (RESTService)resource.core$().ownerAs(RESTService.class);
        Object basePath = Commons.basePath(service.basePath());
        if (service.info() != null && service.info().version() != null) {
            basePath = (String)basePath + service.info().version() + "/";
        }
        String resourcePath = resource.path();
        return ((String)basePath + resourcePath).replace("//", "/");
    }

    private static String basePath(String path) {
        path = !path.isEmpty() && !path.endsWith("/") ? path + "/" : path;
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static Set<String> extractParameters(String text) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }

    public static List<String> extractUrlPathParameters(String url) {
        return Arrays.stream(url.split("/")).filter(s -> s.contains(":")).map(s -> s.replace(":", "")).collect(Collectors.toList());
    }

    public static String returnType(Response response) {
        if (response == null || response.asType() == null) {
            return "void";
        }
        return response.isList() ? "List<" + response.asType().type() + ">" : response.asType().type();
    }

    public static String returnType(Response response, String packageName) {
        if (response == null) {
            return "void";
        }
        if (response.i$(Redirect.class)) {
            return String.class.getName();
        }
        if (response.asType() == null) {
            return "void";
        }
        String innerPackage = response.isObject() && response.asObject().isComponent() ? String.join((CharSequence)".", packageName, "schemas.") : "";
        String type = innerPackage + response.asType().type();
        return response.isList() ? "List<" + type + ">" : type;
    }

    public static int fileParameters(RESTService.Resource.Operation operation) {
        return (int)operation.parameterList().stream().filter(p -> p.i$(FileData.class)).count();
    }

    public static String firstUpperCase(String value) {
        return value.isEmpty() ? "" : value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private static File preparedFile(File packageFolder, String name, String extension) {
        return new File(packageFolder, Commons.prepareName(name) + "." + extension);
    }

    private static String prepareName(String name) {
        return name.isEmpty() ? name : Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

