/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components.other;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.SizedRenderer;
import io.intino.konos.model.graph.Dataframe;
import io.intino.konos.model.graph.OtherComponents;

public class ChartRenderer
extends SizedRenderer<OtherComponents.Chart> {
    public ChartRenderer(Settings settings, OtherComponents.Chart component, TemplateProvider provider, Target target) {
        super(settings, component, provider, target);
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        result.add("query", (Object)this.clean(((OtherComponents.Chart)this.element).query()));
        if (((OtherComponents.Chart)this.element).serverUrl() != null) {
            result.add("serverUrl", (Object)((OtherComponents.Chart)this.element).serverUrl());
        }
        this.addInput(result);
        this.addOutput(result);
        return result;
    }

    private void addInput(FrameBuilder builder) {
        Dataframe input = ((OtherComponents.Chart)this.element).input();
        String type = input.isCustom() ? "source" : "csv";
        builder.add("input", (Object)this.inputMethodFrame(input, type));
    }

    private FrameBuilder inputMethodFrame(Dataframe input, String type) {
        FrameBuilder frame = new FrameBuilder(new String[]{"inputMethod", type}).add("value", (Object)this.value(input));
        this.addOwner(frame);
        return frame;
    }

    private String value(Dataframe input) {
        if (input.isCSV()) {
            return this.fixResourceValue(input.asCSV().datasourceFilename());
        }
        if (input.isCustom()) {
            return input.asCustom().datasourceClass();
        }
        return "";
    }

    private void addOutput(FrameBuilder builder) {
        OtherComponents.Chart.Output output = ((OtherComponents.Chart)this.element).output();
        builder.add("output", (Object)output.name());
    }

    private String clean(String script) {
        return script.replaceAll("\\n", "\\\\n").replaceAll("\\t", "\\\\t").replaceAll("\"", "\\\\\"");
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("image", "");
    }
}

