/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jmx;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.jmx.JMXService;
import java.util.List;

public class JMXServerRenderer
extends Renderer {
    private final List<JMXService> jmxServices;

    public JMXServerRenderer(Settings settings, KonosGraph graph) {
        super(settings, Target.Owner);
        this.jmxServices = graph.jMXServiceList();
    }

    @Override
    public void render() {
        this.jmxServices.forEach(this::processService);
    }

    private void processService(JMXService service) {
        List<JMXService.Operation> operations = service.operationList();
        if (operations.isEmpty()) {
            return;
        }
        Commons.writeFrame(this.gen(), "JMX" + StringHelper.snakeCaseToCamelCase((String)service.name$()), this.template().render((Object)new FrameBuilder(new String[]{"jmxserver"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).toFrame()));
    }

    private Template template() {
        return Formatters.customize(new JMXServerTemplate());
    }
}

