/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.sentinel;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.sentinel.ListenerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Sentinel;
import io.intino.konos.model.graph.directorylistener.DirectoryListenerSentinel;
import io.intino.konos.model.graph.systemlistener.SystemListenerSentinel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ListenerRenderer
extends Renderer {
    private final List<SystemListenerSentinel> systemSentinels;
    private final List<Sentinel> sentinels;

    public ListenerRenderer(Settings settings, KonosGraph graph) {
        super(settings, Target.Owner);
        this.systemSentinels = graph.systemListenerSentinelList();
        this.sentinels = graph.sentinelList().stream().filter(t -> !t.isSystemListener()).collect(Collectors.toList());
    }

    @Override
    public void render() {
        this.systemSentinels.forEach(this::processSystemSentinel);
        this.sentinels.stream().filter(Sentinel::isDirectoryListener).map(Sentinel::asDirectoryListener).forEach(this::processDirectorySentinel);
    }

    private void processSystemSentinel(SystemListenerSentinel sentinel) {
        FrameBuilder builder = this.baseFrame("listener").add("name", (Object)sentinel.name$());
        ArrayList<Frame> targets = new ArrayList<Frame>();
        targets.add(this.baseFrame(sentinel.name$()).add("name", (Object)sentinel.name$()).toFrame());
        builder.add("target", (Object)targets.toArray(new Frame[0]));
        Commons.writeFrame(this.destinyPackage(), sentinel.name$() + "Listener", this.template().render((Object)builder.toFrame()));
        this.createCorrespondingAction((Sentinel)sentinel.a$(Sentinel.class));
    }

    private void processDirectorySentinel(DirectoryListenerSentinel sentinel) {
        FrameBuilder frame = new FrameBuilder(new String[]{"action", "listener"}).add("name", (Object)sentinel.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("parameter", (Object)this.parameters(sentinel));
        if (!this.alreadyRendered(this.src(), (Sentinel)sentinel.a$(Sentinel.class))) {
            Commons.writeFrame(this.actionsPackage(this.src()), sentinel.name$() + "Action", this.actionTemplate().render((Object)frame));
        }
    }

    private Frame[] parameters(DirectoryListenerSentinel sentinel) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        list.add(new FrameBuilder(new String[]{"parameter"}).add("type", (Object)File.class.getCanonicalName()).add("name", (Object)"directory").toFrame());
        list.add(new FrameBuilder(new String[]{"parameter"}).add("type", (Object)"io.intino.alexandria.scheduler.directory.DirectorySentinel.Event").add("name", (Object)"event").toFrame());
        return list.toArray(new Frame[0]);
    }

    private void createCorrespondingAction(Sentinel sentinel) {
        if (!this.alreadyRendered(this.src(), sentinel)) {
            Commons.writeFrame(this.actionsPackage(this.src()), sentinel.name$() + "Action", this.actionTemplate().render((Object)new FrameBuilder(new String[]{"action"}).add("name", (Object)sentinel.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).toFrame()));
        }
    }

    private Template actionTemplate() {
        return Formatters.customize(new ActionTemplate());
    }

    private Template template() {
        return Formatters.customize(new ListenerTemplate());
    }

    private boolean alreadyRendered(File destiny, Sentinel sentinel) {
        return Commons.javaFile(this.actionsPackage(destiny), sentinel.name$() + "Action").exists();
    }

    private File actionsPackage(File destiny) {
        return new File(destiny, "actions");
    }

    private File destinyPackage() {
        return new File(this.gen(), "scheduling");
    }

    @NotNull
    private FrameBuilder baseFrame(String ... types) {
        FrameBuilder frameBuilder = new FrameBuilder(types).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName());
        if (frameBuilder == null) {
            ListenerRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/sentinel/ListenerRenderer", "baseFrame"));
    }
}

