/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.main;

import com.intellij.openapi.module.Module;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.main.MainTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;

public class MainRenderer {
    private final Settings settings;
    private final File destination;
    private final boolean hasModel;
    private final Configuration configuration;

    public MainRenderer(Settings settings, KonosGraph graph, boolean hasModel) {
        this.settings = settings;
        this.destination = settings.src(Target.Owner);
        this.hasModel = hasModel;
        this.configuration = settings.module() != null ? TaraUtil.configurationOf((Module)settings.module()) : null;
    }

    public void execute() {
        if (this.configuration == null) {
            return;
        }
        String name = this.settings.boxName();
        FrameBuilder builder = new FrameBuilder(new String[]{"main"}).add("package", (Object)this.settings.packageName()).add("name", (Object)name);
        if (this.hasModel) {
            builder.add("model", (Object)new FrameBuilder(new String[]{"model"}).add("name", (Object)name).toFrame());
        }
        if (!Commons.javaFile(this.destination, "Main").exists()) {
            Commons.writeFrame(this.destination, "Main", this.template().render((Object)builder.toFrame()));
        }
    }

    private Template template() {
        return Formatters.customize(new MainTemplate());
    }
}

