/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.feeder;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.feeder.AbstractFeederTemplate;
import io.intino.konos.builder.codegeneration.feeder.FeederTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Sensor;
import io.intino.konos.model.graph.documentedition.DocumentEditionSensor;
import io.intino.konos.model.graph.documentsignature.DocumentSignatureSensor;
import io.intino.konos.model.graph.formedition.FormEditionSensor;
import io.intino.konos.model.graph.poll.PollSensor;
import io.intino.konos.model.graph.usersensor.UserSensorSensor;
import io.intino.tara.magritte.Concept;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FeederRenderer {
    private final Settings settings;
    private final List<Feeder> feeders;

    public FeederRenderer(Settings settings, KonosGraph graph) {
        this.settings = settings;
        this.feeders = graph.feederList();
    }

    public void execute() {
        for (Feeder feeder : this.feeders) {
            FrameBuilder builder = new FrameBuilder(new String[]{"feeder", feeder.sensorList().isEmpty() ? "simple" : "complex"}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName()).add("name", (Object)feeder.name$());
            for (Sensor sensor : feeder.sensorList()) {
                builder.add("sensor", (Object)this.frameOf(sensor, feeder.name$()));
            }
            builder.add("eventType", (Object)feeder.tanks().toArray(new String[0]));
            String feederClassName = Commons.firstUpperCase(feeder.name$());
            this.settings.classes().put(((Object)((Object)feeder)).getClass().getSimpleName() + "#" + feeder.name$(), "feeders." + feederClassName);
            Commons.writeFrame(new File(this.settings.gen(Target.Owner), "feeders"), "Abstract" + feederClassName, Formatters.customize(new AbstractFeederTemplate()).render((Object)builder.toFrame()));
            if (this.alreadyRendered(new File(this.settings.src(Target.Owner), "feeders"), feederClassName)) continue;
            Commons.writeFrame(new File(this.settings.src(Target.Owner), "feeders"), feederClassName, Formatters.customize(new FeederTemplate()).render((Object)builder.toFrame()));
        }
    }

    private Frame frameOf(Sensor sensor, String feeder) {
        FrameBuilder builder = new FrameBuilder(new String[]{"sensor"}).add("name", (Object)sensor.name$()).add("feeder", (Object)feeder).add("type", (Object)(((Concept)sensor.core$().conceptList().get(0)).id().replaceAll("#.*", "") + "Sensor")).add("parent", (Object)this.parent(sensor));
        if (sensor.isUserSensor()) {
            UserSensorSensor userSensor = sensor.asUserSensor();
            if (userSensor.width() != 100) {
                builder.add("width", (Object)new FrameBuilder(new String[]{"width"}).add("value", (Object)userSensor.width()));
            }
            if (userSensor.height() != 100) {
                builder.add("height", (Object)new FrameBuilder(new String[]{"height"}).add("value", (Object)userSensor.height()));
            }
        }
        return builder.toFrame();
    }

    private Frame parent(Sensor sensor) {
        if (sensor.isPoll()) {
            return this.poll(sensor.asPoll());
        }
        if (sensor.isFormEdition()) {
            return this.formEdition(sensor.asFormEdition());
        }
        if (sensor.isDocumentEdition()) {
            return this.documentEdition(sensor.asDocumentEdition());
        }
        if (sensor.isDocumentSignature()) {
            return this.documentSignature(sensor.asDocumentSignature());
        }
        return new FrameBuilder().toFrame();
    }

    private Frame poll(PollSensor sensor) {
        return new FrameBuilder(new String[]{"poll"}).add("defaultOption", (Object)(sensor.defaultOption() == null ? "" : sensor.defaultOption())).add("eventMethod", (Object)((Feeder)sensor.core$().ownerAs(Feeder.class)).tanks().toArray(new String[0])).add("option", (Object)this.frameOf(sensor.optionList())).toFrame();
    }

    private Frame[] frameOf(List<PollSensor.Option> options) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (PollSensor.Option option : options) {
            FrameBuilder builder = new FrameBuilder(new String[]{"option"}).add("value", (Object)option.value()).add("event", (Object)option.event().name$());
            if (!option.optionList().isEmpty()) {
                builder.add("option", (Object)this.frameOf(option.optionList()));
            }
            frames.add(builder.toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame formEdition(FormEditionSensor sensor) {
        return new FrameBuilder(new String[]{"formEdition"}).add("path", (Object)sensor.path()).toFrame();
    }

    private Frame documentEdition(DocumentEditionSensor sensor) {
        return new FrameBuilder(new String[]{"documentEdition"}).add("mode", (Object)sensor.mode().name()).toFrame();
    }

    private Frame documentSignature(DocumentSignatureSensor sensor) {
        return new FrameBuilder(new String[]{"documentSignature"}).add("signType", (Object)sensor.signType().name()).add("signFormat", (Object)sensor.signFormat().name()).toFrame();
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

