/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datalake.DatalakeTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Datalake;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.batch.BatchMounter;
import io.intino.konos.model.graph.population.PopulationMounter;
import io.intino.konos.model.graph.realtime.RealtimeMounter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DatalakeRenderer {
    private final Settings settings;
    private final KonosGraph graph;
    private final File genDirectory;

    public DatalakeRenderer(Settings settings, KonosGraph graph) {
        this.graph = graph;
        this.settings = settings;
        this.genDirectory = settings.gen(Target.Owner);
    }

    public void execute() {
        Datalake datalake = this.graph.datalake();
        if (datalake == null || !datalake.isNfsMirrored() && !datalake.isSshMirrored()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"datalake", datalake.isNfsMirrored() ? "nfs" : "ssh"}).add("package", (Object)this.settings.packageName());
        ArrayList eventTanks = new ArrayList();
        this.graph.realtimeMounterList().forEach(mounter -> eventTanks.addAll(this.tanksOf((RealtimeMounter)((Object)mounter))));
        this.graph.batchMounterList().forEach(mounter -> eventTanks.addAll(this.tanksOf((BatchMounter)((Object)mounter))));
        ArrayList setTanks = new ArrayList();
        builder.add("eventTank", (Object)eventTanks.toArray(new String[0]));
        this.graph.populationMounterList().forEach(mounter -> setTanks.addAll(this.tanksOf((PopulationMounter)((Object)mounter))));
        builder.add("setTank", (Object)setTanks.toArray(new String[0]));
        this.settings.classes().put("Datalake", "Datalake");
        File destination = this.genDirectory;
        if (!Commons.javaFile(destination, "Datalake").exists()) {
            Commons.writeFrame(destination, "Datalake", Formatters.customize(new DatalakeTemplate()).render((Object)builder.toFrame()));
        }
    }

    private List<String> tanksOf(BatchMounter mounter) {
        return mounter.sourceList().stream().map(BatchMounter.Source::tank).collect(Collectors.toList());
    }

    private List<String> tanksOf(RealtimeMounter mounter) {
        return mounter.sourceList().stream().map(RealtimeMounter.Source::channel).collect(Collectors.toList());
    }

    private List<String> tanksOf(PopulationMounter mounter) {
        ArrayList<String> tanks = new ArrayList<String>();
        if (!mounter.splitList().isEmpty()) {
            for (PopulationMounter.Split split : mounter.splitList()) {
                split.splits().forEach(s -> mounter.sourceList().stream().map(source -> s + "." + source.tank()).forEach(tanks::add));
            }
        } else {
            return mounter.sourceList().stream().map(PopulationMounter.Source::tank).collect(Collectors.toList());
        }
        return tanks;
    }
}

