/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.cache.ElementCache;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Settings {
    private Project project;
    private Module module;
    private Module webModule;
    private String parent;
    private File res;
    private File src;
    private File gen;
    private ElementCache cache;
    private String packageName;
    private String boxName = null;
    private Map<String, String> classes = new HashMap<String, String>();

    public Settings() {
    }

    public Settings(Module module, File src, File gen, File res, String packageName, ElementCache cache) {
        this.module(module);
        this.project(module == null ? null : module.getProject());
        this.res(res);
        this.src(src);
        this.gen(gen);
        this.packageName(packageName);
        this.cache(cache);
    }

    public Project project() {
        return this.project;
    }

    public Settings project(Project project) {
        this.project = project;
        return this;
    }

    public Module module() {
        return this.module;
    }

    public Settings module(Module module) {
        this.module = module;
        return this;
    }

    public Module webModule() {
        return this.webModule;
    }

    public Settings webModule(Module module) {
        this.webModule = module;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public Settings parent(String parent) {
        this.parent = parent;
        return this;
    }

    public File root(Target target) {
        String rootDir = target == Target.Owner ? this.module().getModuleFilePath() : this.webModule().getModuleFilePath();
        return CodeGenerationHelper.createIfNotExists(new File(rootDir).getParentFile());
    }

    public File res(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? this.res : this.accessorRes());
    }

    public Settings res(File res) {
        this.res = res;
        return this;
    }

    public File src(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? this.src : this.accessorSrc());
    }

    public Settings src(File src) {
        this.src = src;
        return this;
    }

    public File gen(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? this.gen : this.accessorGen());
    }

    public Settings gen(File gen) {
        this.gen = gen;
        return this;
    }

    public ElementCache cache() {
        return this.cache;
    }

    public Settings cache(ElementCache cache) {
        this.cache = cache;
        return this;
    }

    public String packageName() {
        return this.packageName;
    }

    public Settings packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String boxName() {
        if (this.boxName == null) {
            this.boxName = StringHelper.snakeCaseToCamelCase((String)(this.module() != null ? TaraUtil.configurationOf((Module)this.module()).artifactId() : Configuration.Level.Solution.name()));
        }
        return this.boxName;
    }

    public Map<String, String> classes() {
        return this.classes;
    }

    public Settings classes(Map<String, String> classes) {
        this.classes = classes;
        return this;
    }

    private File accessorRes() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "res"));
    }

    private File accessorSrc() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "src"));
    }

    private File accessorGen() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "gen"));
    }

    public Settings clone() {
        Settings result = new Settings();
        result.project = this.project;
        result.module = this.module;
        result.webModule = this.webModule;
        result.parent = this.parent;
        result.res = this.res;
        result.src = this.src;
        result.gen = this.gen;
        result.cache = this.cache;
        result.packageName = this.packageName;
        result.boxName = this.boxName;
        result.classes = this.classes;
        return result;
    }
}

