/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.actions.IntinoTestTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.messaging.MessagingService;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class IntinoTestRenderer {
    private KonosGraph graph;
    private PsiDirectory directory;
    private String newName;

    IntinoTestRenderer(Module module, PsiDirectory directory, String newName) {
        this.directory = directory;
        this.newName = newName;
        this.graph = new GraphLoader().loadGraph(module);
    }

    public String execute() {
        if (this.graph == null) {
            return null;
        }
        FrameBuilder builder = new FrameBuilder();
        builder.add("intinoTest").add("package", (Object)this.calculatePackage()).add("name", (Object)this.newName);
        this.addRESTServices(builder);
        this.addMessagingServices(builder);
        this.addSlackServices(builder);
        this.addUIServices(builder);
        return this.template().render((Object)builder);
    }

    private String calculatePackage() {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(this.directory);
        return aPackage == null ? "" : aPackage.getQualifiedName();
    }

    private void addRESTServices(FrameBuilder builder) {
        for (RESTService service : this.graph.rESTServiceList()) {
            FrameBuilder restBuilder = new FrameBuilder(new String[]{"service"}).add("rest").add("name", (Object)service.name$());
            this.addUserVariables(service.a$(Service.class), restBuilder, this.findCustomParameters(service));
            builder.add("service", (Object)restBuilder.toFrame());
        }
    }

    private void addMessagingServices(FrameBuilder builder) {
        for (MessagingService service : this.graph.messagingServiceList()) {
            FrameBuilder jmsBuilder = new FrameBuilder(new String[]{"service"}).add("jms").add("name", (Object)service.name$());
            this.addUserVariables(service.a$(Service.class), jmsBuilder, this.findCustomParameters(service));
            builder.add("service", (Object)jmsBuilder.toFrame());
        }
    }

    private void addUIServices(FrameBuilder builder) {
        for (UIService service : this.graph.uIServiceList()) {
            FrameBuilder serviceBuilder = new FrameBuilder(new String[]{"service"}).add("ui").add("name", (Object)service.name$());
            builder.add("service", (Object)serviceBuilder);
            if (service.authentication() != null) {
                serviceBuilder.add("auth");
                serviceBuilder.add("auth", (Object)service.authentication().by());
            }
            this.addUserVariables(service, serviceBuilder, this.findCustomParameters(service));
        }
    }

    private void addSlackServices(FrameBuilder builder) {
        for (SlackBotService service : this.graph.slackBotServiceList()) {
            builder.add("service", (Object)new FrameBuilder(new String[]{"service"}).add("slack").add("name", (Object)service.name$()));
        }
    }

    private void addUserVariables(Layer layer, FrameBuilder builder, Collection<String> userVariables) {
        for (String custom : userVariables) {
            builder.add("custom", (Object)new FrameBuilder(new String[]{"custom"}).add("conf", (Object)layer.name$()).add("name", (Object)custom).add("type", (Object)"String"));
        }
    }

    private Set<String> findCustomParameters(MessagingService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (MessagingService.Request request : service.requestList()) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(UIService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (service.authentication() != null) {
            set.addAll(Commons.extractParameters(service.authentication().by()));
        }
        for (AbstractUIService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private VirtualFile getTestRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"test".equals(file.getName())) continue;
            return file;
        }
        return null;
    }

    private Template template() {
        return Formatters.customize(new IntinoTestTemplate());
    }
}

