/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.realtime;

import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.mountertype.MounterTypeMounter;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RealtimeMounter
extends MounterTypeMounter
implements Terminal {
    protected String subscriberId;
    protected List<Source> sourceList = new ArrayList<Source>();

    public RealtimeMounter(Node node) {
        super(node);
    }

    public String subscriberId() {
        return this.subscriberId;
    }

    @Override
    public Datamart datamart() {
        return this._mounter.datamart();
    }

    public RealtimeMounter subscriberId(String value) {
        this.subscriberId = value;
        return this;
    }

    @Override
    public RealtimeMounter datamart(Datamart value) {
        this._mounter.datamart(value);
        return this;
    }

    public List<Source> sourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    public Source source(int index) {
        return this.sourceList.get(index);
    }

    public List<Source> sourceList(Predicate<Source> predicate) {
        return this.sourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Source>(this.sourceList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("subscriberId", new ArrayList<String>(Collections.singletonList(this.subscriberId)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Realtime#Mounter$Source")) {
            this.sourceList.add((Source)node.as(Source.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Realtime#Mounter$Source")) {
            this.sourceList.remove(node.as(Source.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        this._mounter.core$().load((Layer)this._mounter, name, values);
        if (name.equalsIgnoreCase("subscriberId")) {
            this.subscriberId = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        this._mounter.core$().set((Layer)this._mounter, name, values);
        if (name.equalsIgnoreCase("subscriberId")) {
            this.subscriberId = (String)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Source
    extends Layer
    implements Terminal {
        protected String channel;
        protected Schema schema;

        public Source(Node node) {
            super(node);
        }

        public String channel() {
            return this.channel;
        }

        public Schema schema() {
            return this.schema;
        }

        public Source channel(String value) {
            this.channel = value;
            return this;
        }

        public Source schema(Schema value) {
            this.schema = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("channel", new ArrayList<String>(Collections.singletonList(this.channel)));
            map.put("schema", this.schema != null ? new ArrayList<Schema>(Collections.singletonList(this.schema)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("channel")) {
                this.channel = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("schema")) {
                this.schema = (Schema)((Object)NodeLoader.load(values, Schema.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("channel")) {
                this.channel = (String)values.get(0);
            } else if (name.equalsIgnoreCase("schema")) {
                this.schema = values.get(0) != null ? (Schema)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Schema.class) : null;
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void source(Predicate<Source> filter) {
            new ArrayList<Source>(RealtimeMounter.this.sourceList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends MounterTypeMounter.Create {
        public Create(String name) {
            super(name);
        }

        public Source source(String channel, Schema schema) {
            Source newElement = (Source)RealtimeMounter.this.core$().graph().concept(Source.class).createNode(this.name, RealtimeMounter.this.core$()).as(Source.class);
            newElement.core$().set((Layer)newElement, "channel", Collections.singletonList(channel));
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }
    }
}

