/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.highlighted.datacomponents;

import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.PassiveView;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class HighlightedText
extends Layer
implements Terminal {
    protected String textColor;
    protected String backgroundColor;
    protected DataComponents.Text _text;

    public HighlightedText(Node node) {
        super(node);
    }

    public String textColor() {
        return this.textColor;
    }

    public String backgroundColor() {
        return this.backgroundColor;
    }

    public DataComponents.Text.Mode mode() {
        return this._text.mode();
    }

    public String value() {
        return this._text.value();
    }

    public String prefix() {
        return this._text.prefix();
    }

    public String suffix() {
        return this._text.suffix();
    }

    public HighlightedText textColor(String value) {
        this.textColor = value;
        return this;
    }

    public HighlightedText backgroundColor(String value) {
        this.backgroundColor = value;
        return this;
    }

    public HighlightedText mode(DataComponents.Text.Mode value) {
        this._text.mode(value);
        return this;
    }

    public HighlightedText value(String value) {
        this._text.value(value);
        return this;
    }

    public HighlightedText prefix(String value) {
        this._text.prefix(value);
        return this;
    }

    public HighlightedText suffix(String value) {
        this._text.suffix(value);
        return this;
    }

    public List<Block> blockList() {
        return this._text.blockList();
    }

    public Block blockList(int index) {
        return this._text.blockList().get(index);
    }

    public List<PassiveView.Request> requestList() {
        return this._text.requestList();
    }

    public PassiveView.Request requestList(int index) {
        return this._text.requestList().get(index);
    }

    public List<PassiveView.Notification> notificationList() {
        return this._text.notificationList();
    }

    public PassiveView.Notification notificationList(int index) {
        return this._text.notificationList().get(index);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("textColor", new ArrayList<String>(Collections.singletonList(this.textColor)));
        map.put("backgroundColor", new ArrayList<String>(Collections.singletonList(this.backgroundColor)));
        return map;
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("textColor")) {
            this.textColor = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("backgroundColor")) {
            this.backgroundColor = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("textColor")) {
            this.textColor = (String)values.get(0);
        } else if (name.equalsIgnoreCase("backgroundColor")) {
            this.backgroundColor = (String)values.get(0);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof DataComponents.Text) {
            this._text = (DataComponents.Text)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
        public void block(Predicate<Block> filter) {
            new ArrayList<Block>(HighlightedText.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void request(Predicate<PassiveView.Request> filter) {
            new ArrayList<PassiveView.Request>(HighlightedText.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<PassiveView.Notification> filter) {
            new ArrayList<PassiveView.Notification>(HighlightedText.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Block block() {
            Block newElement = (Block)HighlightedText.this.core$().graph().concept(Block.class).createNode(this.name, HighlightedText.this.core$()).as(Block.class);
            return newElement;
        }

        public PassiveView.Request request() {
            PassiveView.Request newElement = (PassiveView.Request)HighlightedText.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, HighlightedText.this.core$()).as(PassiveView.Request.class);
            return newElement;
        }

        public PassiveView.Notification notification() {
            PassiveView.Notification newElement = (PassiveView.Notification)HighlightedText.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, HighlightedText.this.core$()).as(PassiveView.Notification.class);
            return newElement;
        }
    }
}

