/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.batch;

import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.mountertype.MounterTypeMounter;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BatchMounter
extends MounterTypeMounter
implements Terminal {
    protected List<Source> sourceList = new ArrayList<Source>();

    public BatchMounter(Node node) {
        super(node);
    }

    @Override
    public Datamart datamart() {
        return this._mounter.datamart();
    }

    @Override
    public BatchMounter datamart(Datamart value) {
        this._mounter.datamart(value);
        return this;
    }

    public List<Source> sourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    public Source source(int index) {
        return this.sourceList.get(index);
    }

    public List<Source> sourceList(Predicate<Source> predicate) {
        return this.sourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Source>(this.sourceList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Batch#Mounter$Source")) {
            this.sourceList.add((Source)node.as(Source.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Batch#Mounter$Source")) {
            this.sourceList.remove(node.as(Source.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        this._mounter.core$().load((Layer)this._mounter, name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        this._mounter.core$().set((Layer)this._mounter, name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Source
    extends Layer
    implements Terminal {
        protected String tank;

        public Source(Node node) {
            super(node);
        }

        public String tank() {
            return this.tank;
        }

        public Source tank(String value) {
            this.tank = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void source(Predicate<Source> filter) {
            new ArrayList<Source>(BatchMounter.this.sourceList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends MounterTypeMounter.Create {
        public Create(String name) {
            super(name);
        }

        public Source source(String tank) {
            Source newElement = (Source)BatchMounter.this.core$().graph().concept(Source.class).createNode(this.name, BatchMounter.this.core$()).as(Source.class);
            newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
            return newElement;
        }
    }
}

