/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.addressable.passiveview.AddressableRequest;
import io.intino.konos.model.graph.bool.BoolData;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.extensionof.ExtensionOfPassiveView;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.integer.IntegerData;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.real.RealData;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.konos.model.graph.text.TextData;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.word.WordData;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class PassiveView
extends Layer
implements Terminal {
    protected List<Request> requestList = new ArrayList<Request>();
    protected List<Notification> notificationList = new ArrayList<Notification>();

    public PassiveView(Node node) {
        super(node);
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public ExtensionOfPassiveView asExtensionOf() {
        return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
    }

    public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
        ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
        newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
        return newElement;
    }

    public boolean isExtensionOf() {
        return this.core$().is(ExtensionOfPassiveView.class);
    }

    public void removeExtensionOf() {
        this.core$().removeFacet(ExtensionOfPassiveView.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
        new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("PassiveView$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
        if (node.is("PassiveView$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("PassiveView$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
        if (node.is("PassiveView$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Notification
    extends Data
    implements Terminal {
        protected To to;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();

        public Notification(Node node) {
            super(node);
        }

        public To to() {
            return this.to;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public Notification to(To value) {
            this.to = value;
            return this;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.a$(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.core$().addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.core$().is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.a$(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.core$().addFacet(TypeData.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.core$().is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.core$().removeFacet(TypeData.class);
        }

        @Override
        public WordData asWord() {
            return (WordData)this.a$(WordData.class);
        }

        @Override
        public WordData asWord(List<String> values) {
            WordData newElement = (WordData)this.core$().addFacet(WordData.class);
            newElement.core$().set((Layer)newElement, "values", values);
            return newElement;
        }

        @Override
        public boolean isWord() {
            return this.core$().is(WordData.class);
        }

        @Override
        public void removeWord() {
            this.core$().removeFacet(WordData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.a$(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.core$().addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.core$().is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.a$(RealData.class);
            return as != null ? (RealData)as : (RealData)this.core$().addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.core$().is(RealData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.a$(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.core$().addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.core$().is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.a$(TextData.class);
            return as != null ? (TextData)as : (TextData)this.core$().addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.core$().is(TextData.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.a$(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.core$().addFacet(ObjectData.class);
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.core$().is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.core$().removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.a$(ListData.class);
            return as != null ? (ListData)as : (ListData)this.core$().addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.core$().is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.a$(FileData.class);
            return as != null ? (FileData)as : (FileData)this.core$().addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.core$().is(FileData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.a$(DateData.class);
            return as != null ? (DateData)as : (DateData)this.core$().addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.core$().is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.a$(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.core$().addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.core$().is(DateTimeData.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("to", new ArrayList<To>(Collections.singletonList(this.to)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)WordLoader.load(values, To.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Notification.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Notification.this.core$().graph().concept(Exception.class).createNode(this.name, Notification.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum To {
            All,
            Client,
            Display;

        }
    }

    public static class Request
    extends Data
    implements Terminal {
        protected ResponseType responseType;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();

        public Request(Node node) {
            super(node);
        }

        public ResponseType responseType() {
            return this.responseType;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public Request responseType(ResponseType value) {
            this.responseType = value;
            return this;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        public WordData asWord() {
            return (WordData)this.a$(WordData.class);
        }

        @Override
        public WordData asWord(List<String> values) {
            WordData newElement = (WordData)this.core$().addFacet(WordData.class);
            newElement.core$().set((Layer)newElement, "values", values);
            return newElement;
        }

        @Override
        public boolean isWord() {
            return this.core$().is(WordData.class);
        }

        @Override
        public void removeWord() {
            this.core$().removeFacet(WordData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.a$(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.core$().addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.core$().is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.a$(TextData.class);
            return as != null ? (TextData)as : (TextData)this.core$().addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.core$().is(TextData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.a$(DateData.class);
            return as != null ? (DateData)as : (DateData)this.core$().addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.core$().is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.a$(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.core$().addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.core$().is(DateTimeData.class);
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.a$(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.core$().addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.core$().is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.a$(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.core$().addFacet(TypeData.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.core$().is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.core$().removeFacet(TypeData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.a$(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.core$().addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.core$().is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.a$(RealData.class);
            return as != null ? (RealData)as : (RealData)this.core$().addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.core$().is(RealData.class);
        }

        public AddressableRequest asAddressable() {
            return (AddressableRequest)this.a$(AddressableRequest.class);
        }

        public AddressableRequest asAddressable(AbstractUIService.Resource addressableResource) {
            AddressableRequest newElement = (AddressableRequest)this.core$().addFacet(AddressableRequest.class);
            newElement.core$().set((Layer)newElement, "addressableResource", Collections.singletonList(addressableResource));
            return newElement;
        }

        public boolean isAddressable() {
            return this.core$().is(AddressableRequest.class);
        }

        public void removeAddressable() {
            this.core$().removeFacet(AddressableRequest.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.a$(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.core$().addFacet(ObjectData.class);
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.core$().is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.core$().removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.a$(ListData.class);
            return as != null ? (ListData)as : (ListData)this.core$().addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.core$().is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.a$(FileData.class);
            return as != null ? (FileData)as : (FileData)this.core$().addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.core$().is(FileData.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("responseType", new ArrayList<ResponseType>(Collections.singletonList(this.responseType)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)WordLoader.load(values, ResponseType.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Request.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Request.this.core$().graph().concept(Exception.class).createNode(this.name, Request.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum ResponseType {
            Asset,
            Void;

        }
    }

    public class Clear {
        public void request(Predicate<Request> filter) {
            new ArrayList<Request>(PassiveView.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<Notification> filter) {
            new ArrayList<Notification>(PassiveView.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Request request() {
            Request newElement = (Request)PassiveView.this.core$().graph().concept(Request.class).createNode(this.name, PassiveView.this.core$()).as(Request.class);
            return newElement;
        }

        public Notification notification() {
            Notification newElement = (Notification)PassiveView.this.core$().graph().concept(Notification.class).createNode(this.name, PassiveView.this.core$()).as(Notification.class);
            return newElement;
        }
    }
}

