/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.ResourceTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.resource.PageRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.util.List;

public class ResourceRenderer
extends UIRenderer {
    protected final AbstractUIService.Resource resource;

    public ResourceRenderer(Settings settings, AbstractUIService.Resource resource, Target target) {
        super(settings, target);
        this.resource = resource;
    }

    @Override
    public void render() {
        UIService uiService = (UIService)this.resource.core$().ownerAs(UIService.class);
        FrameBuilder builder = this.buildFrame().add("resource").add("name", (Object)this.resource.name$()).add("parameter", (Object)this.parameters(this.resource));
        if (uiService.googleApiKey() != null) {
            builder.add("googleApiKey", (Object)Formatters.customize("googleApiKey", uiService.googleApiKey()));
        }
        if (this.resource.isConfidential()) {
            builder.add("confidential", (Object)"");
        }
        Commons.writeFrame(CodeGenerationHelper.resourceFolder(this.gen(), this.target), CodeGenerationHelper.resourceFilename(this.resource.name$()), this.setup(new ResourceTemplate()).render((Object)builder.toFrame()));
        new PageRenderer(this.settings, this.resource).execute();
    }

    private FrameBuilder[] parameters(AbstractUIService.Resource resource) {
        List<String> parameters = Commons.extractUrlPathParameters(resource.path());
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add("name", parameter)).toArray(FrameBuilder[]::new);
    }
}

