/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRendererFactory;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.AbstractLabeled;
import io.intino.konos.model.graph.AbstractMultiple;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.PrivateComponents;
import io.intino.konos.model.graph.Template;
import io.intino.konos.model.graph.conditional.ConditionalBlock;
import io.intino.konos.model.graph.multiple.MultipleBlock;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleDate;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleFile;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleImage;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleNumber;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleText;
import io.intino.konos.model.graph.multiple.othercomponents.MultipleIcon;
import io.intino.konos.model.graph.multiple.othercomponents.MultipleStamp;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComponentRenderer<C extends Component>
extends DisplayRenderer<C> {
    private boolean buildChildren = false;
    private boolean decorated;
    private Display owner;
    private static final ComponentRendererFactory factory = new ComponentRendererFactory();
    private static final Map<String, FrameBuilder> componentFrameMap = new HashMap<String, FrameBuilder>();

    public ComponentRenderer(Settings settings, C component, TemplateProvider provider, Target target) {
        super(settings, component, provider, target);
        this.decorated = ElementHelper.isRoot(component);
    }

    @Override
    public final FrameBuilder buildFrame() {
        String frameId = this.frameId();
        if (componentFrameMap.containsKey(frameId)) {
            return componentFrameMap.get(frameId);
        }
        FrameBuilder builder = super.buildFrame().add("component");
        this.addOwner(builder);
        this.addProperties(builder);
        if (this.buildChildren) {
            builder.add("child");
        }
        builder.add("methodName", (Object)(((Component)this.element).i$(ConditionalBlock.class) && !((Component)this.element).i$(MultipleBlock.class) ? "initConditional" : "init"));
        this.addSpecificTypes(builder);
        this.addComponents((Component)this.element, builder);
        this.addReferences((Component)this.element, builder);
        this.addFacets((PassiveView)this.element, builder);
        this.addExtends((Component)this.element, builder);
        this.addImplements((Component)this.element, builder);
        this.fill(builder);
        componentFrameMap.put(frameId, builder);
        return builder;
    }

    public static void clearCache() {
        componentFrameMap.clear();
    }

    public void buildChildren(boolean value) {
        this.buildChildren = value;
    }

    public void decorated(boolean value) {
        this.decorated = value;
    }

    public Display owner() {
        return this.owner;
    }

    public void owner(Display owner) {
        this.owner = owner;
    }

    protected FrameBuilder addOwner(FrameBuilder builder) {
        if (this.owner != null) {
            builder.add("owner", (Object)((ElementHelper.isRoot(this.owner) ? "Abstract" : "") + Formatters.firstUpperCase(this.owner.name$())));
        }
        return builder;
    }

    @Override
    protected void addDecoratedFrames(FrameBuilder builder) {
        this.addDecoratedFrames(builder, this.decorated);
    }

    protected void fill(FrameBuilder builder) {
    }

    private void addComponents(Component component, FrameBuilder builder) {
        this.addComponentsImports(builder);
        this.components(component).forEach(c -> {
            FrameBuilder componentBuilder = this.buildChildren ? this.childFrame((Component)((Object)c)) : this.componentFrame((Component)((Object)c));
            builder.add("component", (Object)componentBuilder);
        });
    }

    private void addReferences(Component component, FrameBuilder builder) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>(this.references(component));
        builder.add("componentReferences", (Object)this.componentReferencesFrame());
        components.forEach(c -> builder.add("reference", (Object)this.referenceFrame((Component)((Object)c))));
    }

    private FrameBuilder referenceFrame(Component component) {
        ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.settings, component, this.templateProvider, this.target);
        FrameBuilder builder = new FrameBuilder(new String[]{"reference"}).add(this.typeOf(component)).add("name", (Object)component.name$());
        builder.add("box", (Object)this.boxName());
        builder.add("id", (Object)this.shortId(component));
        builder.add("properties", (Object)renderer.properties());
        this.addOwner(builder);
        this.addExtends(component, builder);
        return builder;
    }

    @Override
    protected FrameBuilder componentFrame(Component component) {
        return this.componentRenderer(component).buildFrame();
    }

    protected FrameBuilder childFrame(Component component) {
        FrameBuilder result = this.componentRenderer(component).buildFrame();
        String[] ancestors = this.ancestors(component);
        Component parent = (Component)component.core$().ownerAs(Component.class);
        if (parent != null) {
            result.add("parent", (Object)this.nameOf(parent));
        }
        result.add("ancestors", (Object)ancestors);
        result.add("ancestorsNotMe", (Object)Arrays.copyOfRange(ancestors, 1, ancestors.length));
        result.add("value", (Object)this.componentRenderer(component).buildFrame().add("addType", (Object)this.typeOf(component)));
        return result;
    }

    public FrameBuilder properties() {
        FrameBuilder result = new FrameBuilder().add("properties").add(this.typeOf(this.element));
        if (((Component)this.element).color() != null && !((Component)this.element).color().isEmpty()) {
            result.add("color", (Object)((Component)this.element).color());
        }
        if (((Component)this.element).isOption()) {
            result.add("name", (Object)((Component)this.element).asOption().name$());
        }
        if (((Component)this.element).i$(AbstractLabeled.class)) {
            result.add("label", (Object)((AbstractLabeled)((Component)this.element).a$(AbstractLabeled.class)).label());
        }
        if (!((Component)this.element).visible()) {
            result.add("visible", (Object)((Component)this.element).visible());
        }
        if (((Component)this.element).i$(AbstractMultiple.class)) {
            AbstractMultiple abstractMultiple = (AbstractMultiple)((Component)this.element).a$(AbstractMultiple.class);
            result.add("instances", (Object)this.nameOf(this.element));
            result.add("multipleArrangement", (Object)abstractMultiple.arrangement().name());
            result.add("multipleSpacing", (Object)abstractMultiple.spacing().value());
            result.add("multipleNoItemsMessage", (Object)(abstractMultiple.noItemsMessage() != null ? abstractMultiple.noItemsMessage() : ""));
        }
        if (((Component)this.element).format() != null) {
            String[] format = (String[])((Component)this.element).format().stream().map(Layer::name$).toArray(String[]::new);
            result.add("format", (Object)format);
        }
        return result;
    }

    protected String className(Class clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    private String[] ancestors(Component component) {
        ArrayList<String> result = new ArrayList<String>();
        Component parent = (Component)component.core$().ownerAs(Component.class);
        while (parent != null) {
            result.add(0, this.nameOf(parent));
            if (parent.i$(CatalogComponents.Collection.Mold.Item.class)) break;
            parent = (Component)parent.core$().ownerAs(Component.class);
        }
        return result.toArray(new String[0]);
    }

    private UIRenderer componentRenderer(Component component) {
        ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.settings, component, this.templateProvider, this.target);
        renderer.buildChildren(true);
        renderer.decorated(this.decorated);
        renderer.owner(this.owner);
        return renderer;
    }

    private List<Component> references(Component component) {
        if (((Component)this.element).i$(PrivateComponents.Row.class)) {
            return ((PrivateComponents.Row)((Component)this.element).a$(PrivateComponents.Row.class)).items().stream().map(i -> (Component)i.a$(Component.class)).collect(Collectors.toList());
        }
        return component.components();
    }

    private void addExtends(Component element, FrameBuilder builder) {
        builder.add("extends", (Object)this.extendsFrame(element, builder));
    }

    protected FrameBuilder extendsFrame(Component element, FrameBuilder builder) {
        FrameBuilder result = new FrameBuilder(new String[]{"extends"});
        if (element.i$(CatalogComponents.Collection.class)) {
            result.add("collection");
        }
        if (element.i$(CatalogComponents.Table.class)) {
            result.add("table");
        }
        result.add("name", (Object)this.nameOf(element));
        if (!this.addSpecificTypes(result)) {
            result.add("type", (Object)this.type());
        }
        this.addFacets(element, result);
        this.addDecoratedFrames(result, this.decorated);
        return result;
    }

    protected boolean addSpecificTypes(FrameBuilder builder) {
        if (((Component)this.element).i$(AbstractMultiple.class)) {
            String message = ((AbstractMultiple)((Component)this.element).a$(AbstractMultiple.class)).noItemsMessage();
            if (message != null) {
                builder.add("noItemsMessage", (Object)message);
            }
            FrameBuilder methodsFrame = this.addOwner(this.buildBaseFrame()).add("method").add("multiple");
            methodsFrame.add("componentType", (Object)this.multipleComponentType((Component)this.element));
            String objectType = this.multipleObjectType((Component)this.element);
            if (objectType != null) {
                methodsFrame.add("objectType", (Object)objectType);
                if (!objectType.equals("java.lang.Void")) {
                    methodsFrame.add("objectTypeValue", (Object)"value");
                }
            }
            methodsFrame.add("name", (Object)this.nameOf(this.element));
            builder.add("methods", (Object)methodsFrame);
            builder.add("multiple");
            builder.add("componentType", (Object)this.multipleComponentType((Component)this.element));
            if (objectType != null) {
                builder.add("objectType", (Object)objectType);
            }
        }
        if (((Component)this.element).i$(Template.class)) {
            builder.add("template");
            String modelClass = ((Template)((Component)this.element).a$(Template.class)).modelClass();
            builder.add("componentType", (Object)this.nameOf(this.element));
            builder.add("objectType", (Object)(modelClass != null ? modelClass : "java.lang.Void"));
            return true;
        }
        if (((Component)this.element).i$(OtherComponents.Stamp.class)) {
            builder.add("stamp");
            if (!((Component)this.element).i$(AbstractMultiple.class)) {
                builder.add("single");
            }
            Template template = ((OtherComponents.Stamp)((Component)this.element).a$(OtherComponents.Stamp.class)).template();
            builder.add("template", (Object)template.name$());
            builder.add("type", (Object)template.name$());
            builder.add("generic", (Object)(KonosGraph.isParentComponent(template) ? "<>" : ""));
            return true;
        }
        if (((Component)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            builder.add("item");
            CatalogComponents.Collection collection = (CatalogComponents.Collection)((CatalogComponents.Collection.Mold.Item)((Component)this.element).a$(CatalogComponents.Collection.Mold.Item.class)).core$().ownerAs(CatalogComponents.Collection.class);
            builder.add("itemClass", (Object)(collection.itemClass() != null ? collection.itemClass() : "java.lang.Void"));
            return true;
        }
        return false;
    }

    private void addProperties(FrameBuilder builder) {
        FrameBuilder properties = this.properties();
        if (properties.slots() <= 0) {
            return;
        }
        builder.add("properties", (Object)this.properties());
    }

    private String multipleComponentType(C element) {
        String prefix = "io.intino.alexandria.ui.displays.components.";
        if (element.i$(MultipleText.class)) {
            return prefix + "Text";
        }
        if (element.i$(MultipleFile.class)) {
            return prefix + "File";
        }
        if (element.i$(MultipleImage.class)) {
            return prefix + "Image";
        }
        if (element.i$(MultipleIcon.class)) {
            return prefix + "Icon";
        }
        if (element.i$(MultipleNumber.class)) {
            return prefix + "Number";
        }
        if (element.i$(MultipleDate.class)) {
            return prefix + "Date";
        }
        if (element.i$(MultipleStamp.class)) {
            return Formatters.firstUpperCase(((MultipleStamp)element.a$(MultipleStamp.class)).template().name$());
        }
        if (element.i$(MultipleBlock.class)) {
            return Formatters.firstUpperCase(this.nameOf((Layer)element));
        }
        return null;
    }

    private String multipleObjectType(C element) {
        if (element.i$(MultipleText.class)) {
            return "java.lang.String";
        }
        if (element.i$(MultipleFile.class)) {
            return "java.net.URL";
        }
        if (element.i$(MultipleImage.class)) {
            return "java.net.URL";
        }
        if (element.i$(MultipleIcon.class)) {
            return "java.net.URL";
        }
        if (element.i$(MultipleNumber.class)) {
            return "java.lang.Double";
        }
        if (element.i$(MultipleDate.class)) {
            return "java.time.Instant";
        }
        if (element.i$(MultipleStamp.class)) {
            String modelClass = ((MultipleStamp)element.a$(MultipleStamp.class)).template().modelClass();
            return modelClass != null ? modelClass : "java.lang.Void";
        }
        if (element.i$(MultipleBlock.class)) {
            return "java.lang.Void";
        }
        return null;
    }

    protected FrameBuilder resourceMethodFrame(String method, String value) {
        FrameBuilder result = new FrameBuilder(new String[]{"resourceMethod"}).add("name", (Object)method).add("value", (Object)this.fixResourceValue(value));
        this.addOwner(result);
        return result;
    }

    protected FrameBuilder parameterMethodFrame(String name, String value) {
        FrameBuilder frame = new FrameBuilder(new String[]{"parameter"});
        frame.add("name", (Object)name);
        frame.add("value", (Object)value);
        this.addOwner(frame);
        return frame;
    }

    protected String fixResourceValue(String value) {
        return value.startsWith("/") ? value : "/" + value;
    }

    private void addImplements(C element, FrameBuilder builder) {
        if (!((Component)((Object)element)).isOption()) {
            return;
        }
        builder.add("implements", (Object)new FrameBuilder(new String[]{"implements", "option"}).add("option", (Object)""));
    }

    private FrameBuilder componentReferencesFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"componentReferences"});
        List<Component> componentList = null;
        if (((Component)this.element).i$(Block.class)) {
            componentList = ((Block)((Component)this.element).a$(Block.class)).componentList();
        } else if (((Component)this.element).i$(Template.class)) {
            componentList = ((Template)((Component)this.element).a$(Template.class)).componentList();
        } else if (((Component)this.element).i$(OtherComponents.Dialog.class)) {
            componentList = ((OtherComponents.Dialog)((Component)this.element).a$(OtherComponents.Dialog.class)).componentList();
        } else if (((Component)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            componentList = ((CatalogComponents.Collection.Mold.Item)((Component)this.element).a$(CatalogComponents.Collection.Mold.Item.class)).componentList();
        }
        if (componentList == null) {
            return result;
        }
        result.add("forRoot");
        componentList.forEach(c -> this.addComponent((Component)((Object)c), result));
        return componentList.size() > 0 ? result : null;
    }

    private String frameId() {
        return this.nameOf(this.element) + (this.owner != null ? this.owner.name$() : "") + this.target.name() + this.buildChildren + this.decorated;
    }
}

