/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.RouteDispatcherTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RouteDispatcherRenderer
extends UIRenderer {
    private final UIService service;

    public RouteDispatcherRenderer(Settings settings, UIService service, Target target) {
        super(settings, target);
        this.service = service;
    }

    @Override
    protected void render() {
        FrameBuilder builder = this.buildFrame();
        CodeGenerationHelper.createIfNotExists(CodeGenerationHelper.displaysFolder(this.src(), this.target));
        File routeDispatcher = CodeGenerationHelper.fileOf(CodeGenerationHelper.displaysFolder(this.src(), this.target), "RouteDispatcher", this.target);
        if (!routeDispatcher.exists()) {
            Commons.write(routeDispatcher.toPath(), this.setup(new RouteDispatcherTemplate()).render((Object)builder.toFrame()));
        }
        Commons.write(CodeGenerationHelper.fileOf(CodeGenerationHelper.displaysFolder(this.gen(), this.target), "AbstractRouteDispatcher", this.target).toPath(), this.setup(new RouteDispatcherTemplate()).render((Object)builder.add("gen").toFrame()));
    }

    @Override
    public FrameBuilder buildFrame() {
        FrameBuilder builder = super.buildFrame();
        builder.add("dispatcher");
        this.service.resourceList().forEach(r -> {
            if (r.isMain()) {
                builder.add("resource", (Object)this.resourceFrame((AbstractUIService.Resource)((Object)r)).add("main"));
            }
            builder.add("resource", (Object)this.resourceFrame((AbstractUIService.Resource)((Object)r)));
        });
        return builder;
    }

    private FrameBuilder resourceFrame(AbstractUIService.Resource resource) {
        FrameBuilder result = new FrameBuilder(new String[]{"resource"});
        result.add("name", (Object)resource.name$());
        result.add("pattern", (Object)this.patternOf(resource));
        this.addResourceParams(resource, result);
        return result;
    }

    private void addResourceParams(AbstractUIService.Resource resource, FrameBuilder result) {
        List<String> params = this.paramsOf(resource);
        for (int i = 0; i < params.size(); ++i) {
            result.add("param", (Object)new FrameBuilder().add("param").add("name", (Object)params.get(i)).add("index", (Object)i));
        }
    }

    private List<String> paramsOf(AbstractUIService.Resource resource) {
        Stream<String> split = Stream.of(resource.path().split("/"));
        return split.filter(s -> s.startsWith(":")).map(s -> s.substring(1)).collect(Collectors.toList());
    }

    private String patternOf(AbstractUIService.Resource resource) {
        if (resource.path().isEmpty()) {
            return "\\\\/";
        }
        Stream<String> split = Stream.of(resource.path().split("/"));
        return split.map(s -> s.startsWith(":") ? "([^\\\\/]*)" : s).collect(Collectors.joining("\\\\/"));
    }
}

