/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.mounter;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.mounter.MounterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.batch.BatchMounter;
import io.intino.konos.model.graph.population.PopulationMounter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MounterRenderer {
    private final Settings settings;
    private final List<Mounter> mounters;
    private final File sourceMounters;
    private File genMounters;

    public MounterRenderer(Settings settings, KonosGraph graph) {
        this.settings = settings;
        this.mounters = graph.mounterList();
        this.sourceMounters = new File(settings.src(Target.Owner), "mounters");
        this.genMounters = new File(settings.gen(Target.Owner), "mounters");
    }

    public void execute() {
        for (Mounter mounter : this.mounters) {
            String mounterName = mounter.name$();
            FrameBuilder builder = this.baseFrame(mounter);
            if (mounter.isPopulation()) {
                this.populationMounter(mounter, mounterName, builder);
                continue;
            }
            if (mounter.isRealtime() && !this.alreadyRendered(this.sourceMounters, mounterName)) {
                this.realtimeMounter(mounter, mounterName, builder);
                continue;
            }
            if (mounter.isRealtime() || this.alreadyRendered(this.sourceMounters, mounterName)) continue;
            this.batchMounter(mounter.asBatch(), mounterName, builder);
        }
    }

    @NotNull
    private FrameBuilder baseFrame(Mounter mounter) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{"mounter"}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName()).add("name", (Object)mounter.name$());
        if (frameBuilder == null) {
            MounterRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private void realtimeMounter(Mounter mounter, String mounterName, FrameBuilder builder) {
        this.realtimeMounter(builder, mounter);
        this.settings.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + mounterName);
        Commons.writeFrame(this.sourceMounters, mounterName, Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
    }

    private void batchMounter(BatchMounter mounter, String mounterName, FrameBuilder builder) {
        builder.add("batch");
        mounter.sourceList().forEach(source -> builder.add("tank", (Object)new FrameBuilder(new String[]{"tank"}).add("qn", (Object)source.tank()).add("name", this.name(source.tank()))));
        Commons.writeFrame(new File(this.settings.src(Target.Owner), "mounters"), mounterName, Formatters.customize(new MounterTemplate()).render((Object)builder));
        this.settings.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + mounterName);
    }

    private void populationMounter(Mounter mounter, String mounterName, FrameBuilder builder) {
        this.populationMounter(builder, mounter.asPopulation());
        this.settings.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + mounterName);
        Commons.writeFrame(this.genMounters, mounter.name$(), Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
        this.mounterFunctions(mounter);
    }

    private void mounterFunctions(Mounter mounter) {
        mounter.asPopulation().clear().split(t -> true);
        FrameBuilder baseFrame = this.baseFrame(mounter).add("src");
        this.populationMounter(baseFrame, mounter.asPopulation());
        if (!this.alreadyRendered(this.sourceMounters, mounter.name$() + "MounterFunctions")) {
            Commons.writeFrame(this.sourceMounters, mounter.name$() + "MounterFunctions", Formatters.customize(new MounterTemplate()).render((Object)baseFrame.toFrame()));
        }
    }

    private void realtimeMounter(FrameBuilder builder, Mounter mounter) {
        builder.add("realtime");
        if (mounter.asRealtime().sourceList().size() == 1) {
            Schema schema = mounter.asRealtime().source(0).schema();
            if (schema != null) {
                String packageName = this.settings.packageName();
                builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)packageName));
                builder.add("type", (Object)new FrameBuilder(new String[]{"schema"}).add("package", (Object)packageName).add("name", (Object)schema.name$()));
            } else {
                builder.add("type", (Object)"message");
            }
        }
    }

    private Object name(String tank) {
        return tank.replace(".", " ");
    }

    private void populationMounter(FrameBuilder builder, PopulationMounter mounter) {
        ArrayList frames = new ArrayList();
        mounter.sourceList().stream().map(this::buildersOf).forEach(frames::addAll);
        builder.add("population").add("column", (Object)frames.toArray(new FrameBuilder[0])).add("datamart", (Object)mounter.datamart().name$()).add("format", (Object)mounter.format().name());
    }

    private List<FrameBuilder> buildersOf(PopulationMounter.Source source) {
        ArrayList<FrameBuilder> builders = new ArrayList<FrameBuilder>();
        for (String tank : this.tanksOf((PopulationMounter)source.core$().ownerAs(PopulationMounter.class), source.tank())) {
            FrameBuilder builder = new FrameBuilder(new String[]{"column"}).add("fullName", (Object)tank).add("name", (Object)source.tank()).add("type", (Object)source.type().name()).add("mounter", (Object)((Mounter)source.core$().ownerAs(Mounter.class)).name$());
            if (source.isId()) {
                builder.add("facet", (Object)"id");
            }
            builders.add(builder);
        }
        return builders;
    }

    private List<String> tanksOf(PopulationMounter mounter, String tank) {
        ArrayList<String> tanks = new ArrayList<String>();
        if (!mounter.splitList().isEmpty()) {
            for (PopulationMounter.Split split : mounter.splitList()) {
                split.splits().stream().map(s -> s + "." + tank).forEach(tanks::add);
            }
        } else {
            return Collections.singletonList(tank);
        }
        return tanks;
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/mounter/MounterRenderer", "baseFrame"));
    }
}

