/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.IncorrectOperationException;
import io.intino.konos.builder.KonosIcons;
import io.intino.konos.builder.actions.IntinoTestRenderer;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import io.intino.tara.plugin.project.module.ModuleProvider;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateKonosTestFileAction
extends JavaCreateTemplateInPackageAction<PsiJavaFile> {
    public CreateKonosTestFileAction() {
        super("Box Test File", "Creates a new Box File", KonosIcons.ICON_16, true);
    }

    protected void buildDialog(Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle("Enter name for new Box Test File");
        builder.addKind("Konos", KonosIcons.ICON_16, "Konos");
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return "Box Test File";
    }

    protected boolean isAvailable(DataContext dataContext) {
        PsiElement data = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return (data instanceof PsiFile || data instanceof PsiDirectory) && super.isAvailable(dataContext);
    }

    @Nullable
    protected PsiElement getNavigationElement(@NotNull PsiJavaFile createdElement) {
        if (createdElement == null) {
            CreateKonosTestFileAction.$$$reportNull$$$0(0);
        }
        return createdElement;
    }

    @Nullable
    protected PsiJavaFile doCreate(PsiDirectory directory, String newName, String dsl) throws IncorrectOperationException {
        String text = new IntinoTestRenderer(ModuleProvider.moduleOf((PsiElement)directory), directory, newName).execute();
        if (text == null) {
            return null;
        }
        String fileName = newName + "." + JavaFileType.INSTANCE.getDefaultExtension();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)directory.getProject());
        PsiFile file = factory.createFileFromText(fileName, (FileType)JavaFileType.INSTANCE, (CharSequence)text);
        return (file = (PsiFile)directory.add((PsiElement)file)) instanceof PsiJavaFile ? (PsiJavaFile)file : null;
    }

    protected void postProcess(PsiJavaFile createdElement, String templateName, Map<String, String> customProperties) {
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
        this.setCaret((PsiFile)createdElement);
        createdElement.navigate(true);
    }

    private void setCaret(PsiFile file) {
        PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)file.getProject());
        Document doc = instance.getDocument(file);
        if (doc == null) {
            return;
        }
        instance.commitDocument(doc);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(KonosIcons.ICON_16);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        boolean enabled = module != null;
        File file = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        if (!file.exists()) {
            return;
        }
        String version = file.getParentFile().getName();
        Configuration configuration = TaraUtil.configurationOf((Module)module);
        if (configuration == null) {
            enabled = false;
        }
        String interfaceVersion = configuration == null ? null : configuration.boxVersion();
        e.getPresentation().setVisible(enabled && version.equals(interfaceVersion));
        e.getPresentation().setEnabled(enabled && version.equals(interfaceVersion));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdElement", "io/intino/konos/builder/actions/CreateKonosTestFileAction", "getNavigationElement"));
    }
}

