/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.population;

import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.constant.population.mounter.ConstantSource;
import io.intino.konos.model.graph.id.population.mounter.IdSource;
import io.intino.konos.model.graph.mountertype.MounterTypeMounter;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PopulationMounter
extends MounterTypeMounter
implements Terminal {
    protected Format format;
    protected List<Split> splitList = new ArrayList<Split>();
    protected List<Source> sourceList = new ArrayList<Source>();
    protected Filter filter;
    protected Aggregation aggregation;

    public PopulationMounter(Node node) {
        super(node);
    }

    public Format format() {
        return this.format;
    }

    @Override
    public Datamart datamart() {
        return this._mounter.datamart();
    }

    public PopulationMounter format(Format value) {
        this.format = value;
        return this;
    }

    @Override
    public PopulationMounter datamart(Datamart value) {
        this._mounter.datamart(value);
        return this;
    }

    public List<Split> splitList() {
        return Collections.unmodifiableList(this.splitList);
    }

    public Split split(int index) {
        return this.splitList.get(index);
    }

    public List<Split> splitList(Predicate<Split> predicate) {
        return this.splitList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Source> sourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    public Source source(int index) {
        return this.sourceList.get(index);
    }

    public List<Source> sourceList(Predicate<Source> predicate) {
        return this.sourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Filter filter() {
        return this.filter;
    }

    public Aggregation aggregation() {
        return this.aggregation;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Split>(this.splitList).forEach(c -> components.add(c.core$()));
        new ArrayList<Source>(this.sourceList).forEach(c -> components.add(c.core$()));
        if (this.filter != null) {
            components.add(this.filter.core$());
        }
        if (this.aggregation != null) {
            components.add(this.aggregation.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("format", new ArrayList<Format>(Collections.singletonList(this.format)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Population#Mounter$Split")) {
            this.splitList.add((Split)node.as(Split.class));
        }
        if (node.is("Population#Mounter$Source")) {
            this.sourceList.add((Source)node.as(Source.class));
        }
        if (node.is("Population#Mounter$Filter")) {
            this.filter = (Filter)node.as(Filter.class);
        }
        if (node.is("Population#Mounter$Aggregation")) {
            this.aggregation = (Aggregation)node.as(Aggregation.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Population#Mounter$Split")) {
            this.splitList.remove(node.as(Split.class));
        }
        if (node.is("Population#Mounter$Source")) {
            this.sourceList.remove(node.as(Source.class));
        }
        if (node.is("Population#Mounter$Filter")) {
            this.filter = null;
        }
        if (node.is("Population#Mounter$Aggregation")) {
            this.aggregation = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        this._mounter.core$().load((Layer)this._mounter, name, values);
        if (name.equalsIgnoreCase("format")) {
            this.format = (Format)((Object)WordLoader.load(values, Format.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        this._mounter.core$().set((Layer)this._mounter, name, values);
        if (name.equalsIgnoreCase("format")) {
            this.format = (Format)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Aggregation
    extends Layer
    implements Terminal {
        protected List<Column> columnList = new ArrayList<Column>();

        public Aggregation(Node node) {
            super(node);
        }

        public List<Column> columnList() {
            return Collections.unmodifiableList(this.columnList);
        }

        public Column column(int index) {
            return this.columnList.get(index);
        }

        public List<Column> columnList(Predicate<Column> predicate) {
            return this.columnList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Column>(this.columnList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Population#Mounter$Aggregation$Column")) {
                this.columnList.add((Column)node.as(Column.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Population#Mounter$Aggregation$Column")) {
                this.columnList.remove(node.as(Column.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Column
        extends Layer
        implements Terminal {
            protected String name;
            protected String tank;
            protected Type type;

            public Column(Node node) {
                super(node);
            }

            public String name() {
                return this.name;
            }

            public String tank() {
                return this.tank;
            }

            public Type type() {
                return this.type;
            }

            public Column name(String value) {
                this.name = value;
                return this;
            }

            public Column tank(String value) {
                this.tank = value;
                return this;
            }

            public Column type(Type value) {
                this.type = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
                map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
                map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("tank")) {
                    this.tank = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)values.get(0);
                } else if (name.equalsIgnoreCase("tank")) {
                    this.tank = (String)values.get(0);
                } else if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)values.get(0));
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static enum Type {
                Boolean,
                String,
                Integer,
                Double,
                Nominal,
                Datetime,
                Instant,
                Long,
                Timetag;

            }
        }

        public class Clear {
            public void column(Predicate<Column> filter) {
                new ArrayList<Column>(Aggregation.this.columnList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Column column(String name, String tank, Column.Type type) {
                Column newElement = (Column)Aggregation.this.core$().graph().concept(Column.class).createNode(this.name, Aggregation.this.core$()).as(Column.class);
                newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
                newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
                newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
                return newElement;
            }
        }
    }

    public static class Filter
    extends Layer
    implements Terminal {
        public Filter(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Source
    extends Layer
    implements Terminal {
        protected String tank;
        protected Type type;

        public Source(Node node) {
            super(node);
        }

        public String tank() {
            return this.tank;
        }

        public Type type() {
            return this.type;
        }

        public Source tank(String value) {
            this.tank = value;
            return this;
        }

        public Source type(Type value) {
            this.type = value;
            return this;
        }

        public ConstantSource asConstant() {
            return (ConstantSource)this.a$(ConstantSource.class);
        }

        public ConstantSource asConstant(String value) {
            ConstantSource newElement = (ConstantSource)this.core$().addFacet(ConstantSource.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public boolean isConstant() {
            return this.core$().is(ConstantSource.class);
        }

        public void removeConstant() {
            this.core$().removeFacet(ConstantSource.class);
        }

        public IdSource asId() {
            Layer as = this.a$(IdSource.class);
            return as != null ? (IdSource)as : (IdSource)this.core$().addFacet(IdSource.class);
        }

        public boolean isId() {
            return this.core$().is(IdSource.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (String)values.get(0);
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Type {
            Boolean,
            String,
            Integer,
            Double,
            Nominal,
            Datetime,
            Instant,
            Long,
            Timetag;

        }
    }

    public static class Split
    extends Layer
    implements Terminal {
        protected List<String> splits = new ArrayList<String>();

        public Split(Node node) {
            super(node);
        }

        public List<String> splits() {
            return this.splits;
        }

        public String splits(int index) {
            return this.splits.get(index);
        }

        public List<String> splits(Predicate<String> predicate) {
            return this.splits().stream().filter(predicate).collect(Collectors.toList());
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("splits", this.splits);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("splits")) {
                this.splits = StringLoader.load(values, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("splits")) {
                this.splits = new ArrayList(values);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void split(Predicate<Split> filter) {
            new ArrayList<Split>(PopulationMounter.this.splitList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void source(Predicate<Source> filter) {
            new ArrayList<Source>(PopulationMounter.this.sourceList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends MounterTypeMounter.Create {
        public Create(String name) {
            super(name);
        }

        public Split split(List<String> splits) {
            Split newElement = (Split)PopulationMounter.this.core$().graph().concept(Split.class).createNode(this.name, PopulationMounter.this.core$()).as(Split.class);
            newElement.core$().set((Layer)newElement, "splits", splits);
            return newElement;
        }

        public Source source(String tank, Source.Type type) {
            Source newElement = (Source)PopulationMounter.this.core$().graph().concept(Source.class).createNode(this.name, PopulationMounter.this.core$()).as(Source.class);
            newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public Filter filter() {
            Filter newElement = (Filter)PopulationMounter.this.core$().graph().concept(Filter.class).createNode(this.name, PopulationMounter.this.core$()).as(Filter.class);
            return newElement;
        }

        public Aggregation aggregation() {
            Aggregation newElement = (Aggregation)PopulationMounter.this.core$().graph().concept(Aggregation.class).createNode(this.name, PopulationMounter.this.core$()).as(Aggregation.class);
            return newElement;
        }
    }

    public static enum Format {
        Arff,
        Tabb,
        Csv;

    }
}

