/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.editable.datacomponents;

import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.Editable;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.PassiveView;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.InstantLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class EditableDate
extends Editable
implements Terminal {
    protected Instant min;
    protected Instant max;
    protected boolean timePicker;
    protected String mask;
    protected boolean allowEmpty;
    protected DataComponents.Date _date;

    public EditableDate(Node node) {
        super(node);
    }

    public Instant min() {
        return this.min;
    }

    public Instant max() {
        return this.max;
    }

    public boolean timePicker() {
        return this.timePicker;
    }

    public String mask() {
        return this.mask;
    }

    public boolean allowEmpty() {
        return this.allowEmpty;
    }

    public String pattern() {
        return this._date.pattern();
    }

    public DataComponents.Date.Mode mode() {
        return this._date.mode();
    }

    public Instant value() {
        return this._date.value();
    }

    public EditableDate min(Instant value) {
        this.min = value;
        return this;
    }

    public EditableDate max(Instant value) {
        this.max = value;
        return this;
    }

    public EditableDate timePicker(boolean value) {
        this.timePicker = value;
        return this;
    }

    public EditableDate mask(String value) {
        this.mask = value;
        return this;
    }

    public EditableDate allowEmpty(boolean value) {
        this.allowEmpty = value;
        return this;
    }

    public EditableDate pattern(String value) {
        this._date.pattern(value);
        return this;
    }

    public EditableDate mode(DataComponents.Date.Mode value) {
        this._date.mode(value);
        return this;
    }

    public EditableDate value(Instant value) {
        this._date.value(value);
        return this;
    }

    public List<Block> blockList() {
        return this._date.blockList();
    }

    public Block blockList(int index) {
        return this._date.blockList().get(index);
    }

    public List<PassiveView.Request> requestList() {
        return this._date.requestList();
    }

    public PassiveView.Request requestList(int index) {
        return this._date.requestList().get(index);
    }

    public List<PassiveView.Notification> notificationList() {
        return this._date.notificationList();
    }

    public PassiveView.Notification notificationList(int index) {
        return this._date.notificationList().get(index);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("min", new ArrayList<Instant>(Collections.singletonList(this.min)));
        map.put("max", new ArrayList<Instant>(Collections.singletonList(this.max)));
        map.put("timePicker", new ArrayList<Boolean>(Collections.singletonList(this.timePicker)));
        map.put("mask", new ArrayList<String>(Collections.singletonList(this.mask)));
        map.put("allowEmpty", new ArrayList<Boolean>(Collections.singletonList(this.allowEmpty)));
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("min")) {
            this.min = (Instant)InstantLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("max")) {
            this.max = (Instant)InstantLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("timePicker")) {
            this.timePicker = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("mask")) {
            this.mask = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("allowEmpty")) {
            this.allowEmpty = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("min")) {
            this.min = (Instant)values.get(0);
        } else if (name.equalsIgnoreCase("max")) {
            this.max = (Instant)values.get(0);
        } else if (name.equalsIgnoreCase("timePicker")) {
            this.timePicker = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("mask")) {
            this.mask = (String)values.get(0);
        } else if (name.equalsIgnoreCase("allowEmpty")) {
            this.allowEmpty = (Boolean)values.get(0);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof DataComponents.Date) {
            this._date = (DataComponents.Date)layer;
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
        public void block(Predicate<Block> filter) {
            new ArrayList<Block>(EditableDate.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void request(Predicate<PassiveView.Request> filter) {
            new ArrayList<PassiveView.Request>(EditableDate.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<PassiveView.Notification> filter) {
            new ArrayList<PassiveView.Notification>(EditableDate.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Editable.Create {
        public Create(String name) {
            super(name);
        }

        public Block block() {
            Block newElement = (Block)EditableDate.this.core$().graph().concept(Block.class).createNode(this.name, EditableDate.this.core$()).as(Block.class);
            return newElement;
        }

        public PassiveView.Request request() {
            PassiveView.Request newElement = (PassiveView.Request)EditableDate.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, EditableDate.this.core$()).as(PassiveView.Request.class);
            return newElement;
        }

        public PassiveView.Notification notification() {
            PassiveView.Notification newElement = (PassiveView.Notification)EditableDate.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, EditableDate.this.core$()).as(PassiveView.Notification.class);
            return newElement;
        }
    }
}

