/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.drawer;

import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.rules.Layout;
import io.intino.konos.model.graph.rules.Spacing;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class DrawerBlock
extends Layer
implements Terminal {
    protected Position position;
    protected Variant variant;
    protected Block _block;

    public DrawerBlock(Node node) {
        super(node);
    }

    public Position position() {
        return this.position;
    }

    public Variant variant() {
        return this.variant;
    }

    public List<Layout> layout() {
        return this._block.layout();
    }

    public Spacing spacing() {
        return this._block.spacing();
    }

    public Block.Hidden hidden() {
        return this._block.hidden();
    }

    public DrawerBlock position(Position value) {
        this.position = value;
        return this;
    }

    public DrawerBlock variant(Variant value) {
        this.variant = value;
        return this;
    }

    public DrawerBlock layout(List<Layout> values) {
        this._block.layout(values);
        return this;
    }

    public DrawerBlock spacing(Spacing value) {
        this._block.spacing(value);
        return this;
    }

    public DrawerBlock hidden(Block.Hidden value) {
        this._block.hidden(value);
        return this;
    }

    public List<Component> componentList() {
        return this._block.componentList();
    }

    public Component componentList(int index) {
        return this._block.componentList().get(index);
    }

    public List<Block> blockList() {
        return this._block.blockList();
    }

    public Block blockList(int index) {
        return this._block.blockList().get(index);
    }

    public List<PassiveView.Request> requestList() {
        return this._block.requestList();
    }

    public PassiveView.Request requestList(int index) {
        return this._block.requestList().get(index);
    }

    public List<PassiveView.Notification> notificationList() {
        return this._block.notificationList();
    }

    public PassiveView.Notification notificationList(int index) {
        return this._block.notificationList().get(index);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
        map.put("variant", new ArrayList<Variant>(Collections.singletonList(this.variant)));
        return map;
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("position")) {
            this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("variant")) {
            this.variant = (Variant)((Object)WordLoader.load(values, Variant.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("position")) {
            this.position = (Position)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("variant")) {
            this.variant = (Variant)((Object)values.get(0));
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Block) {
            this._block = (Block)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(DrawerBlock.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void block(Predicate<Block> filter) {
            new ArrayList<Block>(DrawerBlock.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void request(Predicate<PassiveView.Request> filter) {
            new ArrayList<PassiveView.Request>(DrawerBlock.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<PassiveView.Notification> filter) {
            new ArrayList<PassiveView.Notification>(DrawerBlock.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Component component() {
            Component newElement = (Component)DrawerBlock.this.core$().graph().concept(Component.class).createNode(this.name, DrawerBlock.this.core$()).as(Component.class);
            return newElement;
        }

        public Block block() {
            Block newElement = (Block)DrawerBlock.this.core$().graph().concept(Block.class).createNode(this.name, DrawerBlock.this.core$()).as(Block.class);
            return newElement;
        }

        public PassiveView.Request request() {
            PassiveView.Request newElement = (PassiveView.Request)DrawerBlock.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, DrawerBlock.this.core$()).as(PassiveView.Request.class);
            return newElement;
        }

        public PassiveView.Notification notification() {
            PassiveView.Notification newElement = (PassiveView.Notification)DrawerBlock.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, DrawerBlock.this.core$()).as(PassiveView.Notification.class);
            return newElement;
        }
    }

    public static enum Variant {
        Permanent,
        Persistent,
        PersistentAndMini,
        Temporary;

    }

    public static enum Position {
        Left,
        Top,
        Bottom,
        Right;

    }
}

