/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.AbstractGraph;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.PrivateComponents;
import io.intino.konos.model.graph.Template;
import io.intino.konos.model.graph.extensionof.ExtensionOfPassiveView;
import io.intino.konos.model.graph.messaging.MessagingService;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.magritte.Graph;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class KonosGraph
extends AbstractGraph {
    private static Set<String> hierarchyDisplays = null;
    private static List<CatalogComponents.Collection.Mold.Item> items = null;
    private static List<PrivateComponents.Row> rows = null;
    private static List<CatalogComponents.Table> tables = null;

    public KonosGraph(Graph graph) {
        super(graph);
    }

    public KonosGraph(Graph graph, KonosGraph wrapper) {
        super(graph, wrapper);
    }

    public KonosGraph init() {
        this.resetCache();
        this.createPrivateComponents();
        return this;
    }

    private void resetCache() {
        tables = null;
        items = null;
        rows = null;
    }

    public List<Display> rootDisplays() {
        KonosGraph graph = this;
        List<Display> rootDisplays = graph.displayList().stream().filter(d -> d.core$().ownerAs(PassiveView.class) == null).collect(Collectors.toList());
        rootDisplays.addAll(this.itemsDisplays());
        rootDisplays.addAll(this.rowsDisplays());
        return rootDisplays;
    }

    public List<CatalogComponents.Collection.Mold.Item> itemsDisplays() {
        if (items == null) {
            items = this.core$().find(CatalogComponents.Collection.Mold.Item.class);
        }
        return items;
    }

    public List<PrivateComponents.Row> rowsDisplays() {
        if (rows == null) {
            rows = this.core$().find(PrivateComponents.Row.class);
        }
        return rows;
    }

    public static List<CatalogComponents.Table> tablesDisplays(KonosGraph graph) {
        if (tables == null) {
            tables = graph.core$().find(CatalogComponents.Table.class);
        }
        return tables;
    }

    public static Template templateFor(AbstractUIService.Resource resource) {
        UIService uiService = (UIService)resource.core$().ownerAs(UIService.class);
        return uiService.template(resource);
    }

    public static boolean isParentComponent(Component component) {
        KonosGraph.loadParentComponents(component.graph());
        return hierarchyDisplays.contains(component.name$());
    }

    public Set<String> findCustomParameters(MessagingService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (MessagingService.Request request : service.requestList()) {
            set.addAll(KonosGraph.extractParameters(request.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(KonosGraph.extractParameters(resource.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(UIService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (service.authentication() != null) {
            set.addAll(KonosGraph.extractParameters(service.authentication().by()));
        }
        for (AbstractUIService.Resource resource : service.resourceList()) {
            set.addAll(KonosGraph.extractParameters(resource.path()));
        }
        return set;
    }

    private static Set<String> extractParameters(String text) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }

    private static void loadParentComponents(KonosGraph graph) {
        if (hierarchyDisplays != null) {
            return;
        }
        hierarchyDisplays = graph.core$().find(ExtensionOfPassiveView.class).stream().map(d -> ((ExtensionOfPassiveView)d.core$().as(ExtensionOfPassiveView.class)).parentView().name$()).collect(Collectors.toSet());
    }

    private void createPrivateComponents() {
        KonosGraph.tablesDisplays(this).forEach(this::createUiTableRow);
    }

    private void createUiTableRow(CatalogComponents.Table element) {
        List<CatalogComponents.Collection.Mold.Item> itemList = element.moldList().stream().map(CatalogComponents.Collection.Mold::item).collect(Collectors.toList());
        String name = KonosGraph.firstUpperCase(element.name$()) + "Row";
        PrivateComponents privateComponents = this.privateComponentsList().size() <= 0 ? this.create().privateComponents() : this.privateComponents(0);
        PrivateComponents.Row row = privateComponents.rowList().stream().filter(c -> c.name$().equals(name)).findFirst().orElse(null);
        if (row == null) {
            privateComponents.create(name).row(itemList);
        }
    }

    private static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }
}

