/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Source;
import io.intino.konos.model.graph.csv.CSVDataframe;
import io.intino.konos.model.graph.custom.CustomDataframe;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Dataframe
extends Source
implements Terminal {
    protected List<Column> columnList = new ArrayList<Column>();

    public Dataframe(Node node) {
        super(node);
    }

    public List<Column> columnList() {
        return Collections.unmodifiableList(this.columnList);
    }

    public Column column(int index) {
        return this.columnList.get(index);
    }

    public List<Column> columnList(Predicate<Column> predicate) {
        return this.columnList().stream().filter(predicate).collect(Collectors.toList());
    }

    public CSVDataframe asCSV() {
        return (CSVDataframe)this.a$(CSVDataframe.class);
    }

    public CSVDataframe asCSV(String datasourceFilename) {
        CSVDataframe newElement = (CSVDataframe)this.core$().addFacet(CSVDataframe.class);
        newElement.core$().set((Layer)newElement, "datasourceFilename", Collections.singletonList(datasourceFilename));
        return newElement;
    }

    public boolean isCSV() {
        return this.core$().is(CSVDataframe.class);
    }

    public void removeCSV() {
        this.core$().removeFacet(CSVDataframe.class);
    }

    public CustomDataframe asCustom() {
        return (CustomDataframe)this.a$(CustomDataframe.class);
    }

    public CustomDataframe asCustom(String datasourceClass) {
        CustomDataframe newElement = (CustomDataframe)this.core$().addFacet(CustomDataframe.class);
        newElement.core$().set((Layer)newElement, "datasourceClass", Collections.singletonList(datasourceClass));
        return newElement;
    }

    public boolean isCustom() {
        return this.core$().is(CustomDataframe.class);
    }

    public void removeCustom() {
        this.core$().removeFacet(CustomDataframe.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Column>(this.columnList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Dataframe$Column")) {
            this.columnList.add((Column)node.as(Column.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Dataframe$Column")) {
            this.columnList.remove(node.as(Column.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Column
    extends Layer
    implements Terminal {
        protected String name;
        protected Type type;

        public Column(Node node) {
            super(node);
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.type;
        }

        public Column name(String value) {
            this.name = value;
            return this;
        }

        public Column type(Type value) {
            this.type = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Type {
            String,
            Integer,
            Double,
            Boolean;

        }
    }

    public class Clear {
        public void column(Predicate<Column> filter) {
            new ArrayList<Column>(Dataframe.this.columnList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Source.Create {
        public Create(String name) {
            super(name);
        }

        public Column column(String name, Column.Type type) {
            Column newElement = (Column)Dataframe.this.core$().graph().concept(Column.class).createNode(this.name, Dataframe.this.core$()).as(Column.class);
            newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }
    }
}

