/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.absolute.datacomponents.AbsoluteFile;
import io.intino.konos.model.graph.absolute.datacomponents.AbsoluteImage;
import io.intino.konos.model.graph.accessible.AccessibleDisplay;
import io.intino.konos.model.graph.avatar.datacomponents.AvatarImage;
import io.intino.konos.model.graph.code.datacomponents.CodeText;
import io.intino.konos.model.graph.collapsetriggerer.CollapseTriggererComponent;
import io.intino.konos.model.graph.collapsible.CollapsibleBlock;
import io.intino.konos.model.graph.decorated.DecoratedDisplay;
import io.intino.konos.model.graph.dynamicloaded.DynamicLoadedComponent;
import io.intino.konos.model.graph.editable.datacomponents.EditableDate;
import io.intino.konos.model.graph.editable.datacomponents.EditableFile;
import io.intino.konos.model.graph.editable.datacomponents.EditableImage;
import io.intino.konos.model.graph.editable.datacomponents.EditableLocation;
import io.intino.konos.model.graph.editable.datacomponents.EditableNumber;
import io.intino.konos.model.graph.editable.datacomponents.EditableText;
import io.intino.konos.model.graph.extensionof.ExtensionOfPassiveView;
import io.intino.konos.model.graph.focused.datacomponents.FocusedDate;
import io.intino.konos.model.graph.focused.datacomponents.FocusedFile;
import io.intino.konos.model.graph.focused.datacomponents.FocusedImage;
import io.intino.konos.model.graph.focused.datacomponents.FocusedLocation;
import io.intino.konos.model.graph.focused.datacomponents.FocusedNumber;
import io.intino.konos.model.graph.focused.datacomponents.FocusedText;
import io.intino.konos.model.graph.highlighted.datacomponents.HighlightedText;
import io.intino.konos.model.graph.labeled.LabeledComponent;
import io.intino.konos.model.graph.memo.datacomponents.MemoText;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleDate;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleFile;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleImage;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleNumber;
import io.intino.konos.model.graph.multiple.datacomponents.MultipleText;
import io.intino.konos.model.graph.option.OptionComponent;
import io.intino.konos.model.graph.password.datacomponents.PasswordText;
import io.intino.konos.model.graph.readonly.datacomponents.ReadonlyDate;
import io.intino.konos.model.graph.readonly.datacomponents.ReadonlyFile;
import io.intino.konos.model.graph.readonly.datacomponents.ReadonlyImage;
import io.intino.konos.model.graph.readonly.datacomponents.ReadonlyLocation;
import io.intino.konos.model.graph.readonly.datacomponents.ReadonlyNumber;
import io.intino.konos.model.graph.readonly.datacomponents.ReadonlyText;
import io.intino.konos.model.graph.relative.datacomponents.RelativeFile;
import io.intino.konos.model.graph.relative.datacomponents.RelativeImage;
import io.intino.konos.model.graph.required.datacomponents.RequiredDate;
import io.intino.konos.model.graph.required.datacomponents.RequiredFile;
import io.intino.konos.model.graph.required.datacomponents.RequiredImage;
import io.intino.konos.model.graph.required.datacomponents.RequiredLocation;
import io.intino.konos.model.graph.required.datacomponents.RequiredNumber;
import io.intino.konos.model.graph.required.datacomponents.RequiredText;
import io.intino.konos.model.graph.rules.CodeLanguage;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.InstantLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DataComponents
extends Layer
implements Terminal {
    protected List<Text> textList = new ArrayList<Text>();
    protected List<File> fileList = new ArrayList<File>();
    protected List<Image> imageList = new ArrayList<Image>();
    protected List<Number> numberList = new ArrayList<Number>();
    protected List<Date> dateList = new ArrayList<Date>();
    protected List<Location> locationList = new ArrayList<Location>();

    public DataComponents(Node node) {
        super(node);
    }

    public List<Text> textList() {
        return Collections.unmodifiableList(this.textList);
    }

    public Text text(int index) {
        return this.textList.get(index);
    }

    public List<Text> textList(Predicate<Text> predicate) {
        return this.textList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<File> fileList() {
        return Collections.unmodifiableList(this.fileList);
    }

    public File file(int index) {
        return this.fileList.get(index);
    }

    public List<File> fileList(Predicate<File> predicate) {
        return this.fileList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Image> imageList() {
        return Collections.unmodifiableList(this.imageList);
    }

    public Image image(int index) {
        return this.imageList.get(index);
    }

    public List<Image> imageList(Predicate<Image> predicate) {
        return this.imageList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Number> numberList() {
        return Collections.unmodifiableList(this.numberList);
    }

    public Number number(int index) {
        return this.numberList.get(index);
    }

    public List<Number> numberList(Predicate<Number> predicate) {
        return this.numberList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Date> dateList() {
        return Collections.unmodifiableList(this.dateList);
    }

    public Date date(int index) {
        return this.dateList.get(index);
    }

    public List<Date> dateList(Predicate<Date> predicate) {
        return this.dateList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Location> locationList() {
        return Collections.unmodifiableList(this.locationList);
    }

    public Location location(int index) {
        return this.locationList.get(index);
    }

    public List<Location> locationList(Predicate<Location> predicate) {
        return this.locationList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Text>(this.textList).forEach(c -> components.add(c.core$()));
        new ArrayList<File>(this.fileList).forEach(c -> components.add(c.core$()));
        new ArrayList<Image>(this.imageList).forEach(c -> components.add(c.core$()));
        new ArrayList<Number>(this.numberList).forEach(c -> components.add(c.core$()));
        new ArrayList<Date>(this.dateList).forEach(c -> components.add(c.core$()));
        new ArrayList<Location>(this.locationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("DataComponents$Text")) {
            this.textList.add((Text)node.as(Text.class));
        }
        if (node.is("DataComponents$File")) {
            this.fileList.add((File)node.as(File.class));
        }
        if (node.is("DataComponents$Image")) {
            this.imageList.add((Image)node.as(Image.class));
        }
        if (node.is("DataComponents$Number")) {
            this.numberList.add((Number)node.as(Number.class));
        }
        if (node.is("DataComponents$Date")) {
            this.dateList.add((Date)node.as(Date.class));
        }
        if (node.is("DataComponents$Location")) {
            this.locationList.add((Location)node.as(Location.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("DataComponents$Text")) {
            this.textList.remove(node.as(Text.class));
        }
        if (node.is("DataComponents$File")) {
            this.fileList.remove(node.as(File.class));
        }
        if (node.is("DataComponents$Image")) {
            this.imageList.remove(node.as(Image.class));
        }
        if (node.is("DataComponents$Number")) {
            this.numberList.remove(node.as(Number.class));
        }
        if (node.is("DataComponents$Date")) {
            this.dateList.remove(node.as(Date.class));
        }
        if (node.is("DataComponents$Location")) {
            this.locationList.remove(node.as(Location.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Location
    extends Component
    implements Terminal {
        protected String icon;
        protected String value;
        protected Center center;
        protected Zoom zoom;

        public Location(Node node) {
            super(node);
        }

        public String icon() {
            return this.icon;
        }

        public String value() {
            return this.value;
        }

        public Location icon(String value) {
            this.icon = value;
            return this;
        }

        public Location value(String value) {
            this.value = value;
            return this;
        }

        public Center center() {
            return this.center;
        }

        public Zoom zoom() {
            return this.zoom;
        }

        public ReadonlyLocation asReadonly() {
            Layer as = this.a$(ReadonlyLocation.class);
            return as != null ? (ReadonlyLocation)as : (ReadonlyLocation)this.core$().addFacet(ReadonlyLocation.class);
        }

        public boolean isReadonly() {
            return this.core$().is(ReadonlyLocation.class);
        }

        public RequiredLocation asRequired() {
            Layer as = this.a$(RequiredLocation.class);
            return as != null ? (RequiredLocation)as : (RequiredLocation)this.core$().addFacet(RequiredLocation.class);
        }

        public boolean isRequired() {
            return this.core$().is(RequiredLocation.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf() {
            return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
            ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
            newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
            return newElement;
        }

        @Override
        public boolean isExtensionOf() {
            return this.core$().is(ExtensionOfPassiveView.class);
        }

        @Override
        public void removeExtensionOf() {
            this.core$().removeFacet(ExtensionOfPassiveView.class);
        }

        @Override
        public LabeledComponent asLabeled() {
            return (LabeledComponent)this.a$(LabeledComponent.class);
        }

        @Override
        public LabeledComponent asLabeled(String label) {
            LabeledComponent newElement = (LabeledComponent)this.core$().addFacet(LabeledComponent.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        @Override
        public boolean isLabeled() {
            return this.core$().is(LabeledComponent.class);
        }

        @Override
        public void removeLabeled() {
            this.core$().removeFacet(LabeledComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer() {
            return (CollapseTriggererComponent)this.a$(CollapseTriggererComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer(CollapsibleBlock for$) {
            CollapseTriggererComponent newElement = (CollapseTriggererComponent)this.core$().addFacet(CollapseTriggererComponent.class);
            newElement.core$().set((Layer)newElement, "for", Collections.singletonList(for$));
            return newElement;
        }

        @Override
        public boolean isCollapseTriggerer() {
            return this.core$().is(CollapseTriggererComponent.class);
        }

        @Override
        public void removeCollapseTriggerer() {
            this.core$().removeFacet(CollapseTriggererComponent.class);
        }

        public EditableLocation asEditable() {
            Layer as = this.a$(EditableLocation.class);
            return as != null ? (EditableLocation)as : (EditableLocation)this.core$().addFacet(EditableLocation.class);
        }

        public boolean isEditable() {
            return this.core$().is(EditableLocation.class);
        }

        @Override
        public OptionComponent asOption() {
            Layer as = this.a$(OptionComponent.class);
            return as != null ? (OptionComponent)as : (OptionComponent)this.core$().addFacet(OptionComponent.class);
        }

        @Override
        public boolean isOption() {
            return this.core$().is(OptionComponent.class);
        }

        @Override
        public DynamicLoadedComponent asDynamicLoaded() {
            Layer as = this.a$(DynamicLoadedComponent.class);
            return as != null ? (DynamicLoadedComponent)as : (DynamicLoadedComponent)this.core$().addFacet(DynamicLoadedComponent.class);
        }

        @Override
        public boolean isDynamicLoaded() {
            return this.core$().is(DynamicLoadedComponent.class);
        }

        @Override
        public DecoratedDisplay asDecorated() {
            Layer as = this.a$(DecoratedDisplay.class);
            return as != null ? (DecoratedDisplay)as : (DecoratedDisplay)this.core$().addFacet(DecoratedDisplay.class);
        }

        @Override
        public boolean isDecorated() {
            return this.core$().is(DecoratedDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible() {
            return (AccessibleDisplay)this.a$(AccessibleDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible(List<String> parameters) {
            AccessibleDisplay newElement = (AccessibleDisplay)this.core$().addFacet(AccessibleDisplay.class);
            newElement.core$().set((Layer)newElement, "parameters", parameters);
            return newElement;
        }

        @Override
        public boolean isAccessible() {
            return this.core$().is(AccessibleDisplay.class);
        }

        @Override
        public void removeAccessible() {
            this.core$().removeFacet(AccessibleDisplay.class);
        }

        public FocusedLocation asFocused() {
            Layer as = this.a$(FocusedLocation.class);
            return as != null ? (FocusedLocation)as : (FocusedLocation)this.core$().addFacet(FocusedLocation.class);
        }

        public boolean isFocused() {
            return this.core$().is(FocusedLocation.class);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.center != null) {
                components.add(this.center.core$());
            }
            if (this.zoom != null) {
                components.add(this.zoom.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("icon", new ArrayList<String>(Collections.singletonList(this.icon)));
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("DataComponents$Location$Center")) {
                this.center = (Center)node.as(Center.class);
            }
            if (node.is("DataComponents$Location$Zoom")) {
                this.zoom = (Zoom)node.as(Zoom.class);
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("DataComponents$Location$Center")) {
                this.center = null;
            }
            if (node.is("DataComponents$Location$Zoom")) {
                this.zoom = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)values.get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Zoom
        extends Layer
        implements Terminal {
            protected int defaultZoom;
            protected int min;
            protected int max;

            public Zoom(Node node) {
                super(node);
            }

            public int defaultZoom() {
                return this.defaultZoom;
            }

            public int min() {
                return this.min;
            }

            public int max() {
                return this.max;
            }

            public Zoom defaultZoom(int value) {
                this.defaultZoom = value;
                return this;
            }

            public Zoom min(int value) {
                this.min = value;
                return this;
            }

            public Zoom max(int value) {
                this.max = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("defaultZoom", new ArrayList<Integer>(Collections.singletonList(this.defaultZoom)));
                map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("defaultZoom")) {
                    this.defaultZoom = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("defaultZoom")) {
                    this.defaultZoom = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Center
        extends Layer
        implements Terminal {
            protected double latitude;
            protected double longitude;

            public Center(Node node) {
                super(node);
            }

            public double latitude() {
                return this.latitude;
            }

            public double longitude() {
                return this.longitude;
            }

            public Center latitude(double value) {
                this.latitude = value;
                return this;
            }

            public Center longitude(double value) {
                this.longitude = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("latitude", new ArrayList<Double>(Collections.singletonList(this.latitude)));
                map.put("longitude", new ArrayList<Double>(Collections.singletonList(this.longitude)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear
        extends Display.Clear {
        }

        public class Create
        extends Display.Create {
            public Create(String name) {
                super(name);
            }

            public Center center(double latitude, double longitude) {
                Center newElement = (Center)Location.this.core$().graph().concept(Center.class).createNode(this.name, Location.this.core$()).as(Center.class);
                newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                return newElement;
            }

            public Zoom zoom(int defaultZoom, int min, int max) {
                Zoom newElement = (Zoom)Location.this.core$().graph().concept(Zoom.class).createNode(this.name, Location.this.core$()).as(Zoom.class);
                newElement.core$().set((Layer)newElement, "defaultZoom", Collections.singletonList(defaultZoom));
                newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                return newElement;
            }
        }
    }

    public static class Date
    extends Component
    implements Terminal {
        protected String pattern;
        protected Mode mode;
        protected Instant value;

        public Date(Node node) {
            super(node);
        }

        public String pattern() {
            return this.pattern;
        }

        public Mode mode() {
            return this.mode;
        }

        public Instant value() {
            return this.value;
        }

        public Date pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Date mode(Mode value) {
            this.mode = value;
            return this;
        }

        public Date value(Instant value) {
            this.value = value;
            return this;
        }

        public MultipleDate asMultiple() {
            Layer as = this.a$(MultipleDate.class);
            return as != null ? (MultipleDate)as : (MultipleDate)this.core$().addFacet(MultipleDate.class);
        }

        public boolean isMultiple() {
            return this.core$().is(MultipleDate.class);
        }

        public ReadonlyDate asReadonly() {
            Layer as = this.a$(ReadonlyDate.class);
            return as != null ? (ReadonlyDate)as : (ReadonlyDate)this.core$().addFacet(ReadonlyDate.class);
        }

        public boolean isReadonly() {
            return this.core$().is(ReadonlyDate.class);
        }

        public RequiredDate asRequired() {
            Layer as = this.a$(RequiredDate.class);
            return as != null ? (RequiredDate)as : (RequiredDate)this.core$().addFacet(RequiredDate.class);
        }

        public boolean isRequired() {
            return this.core$().is(RequiredDate.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf() {
            return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
            ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
            newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
            return newElement;
        }

        @Override
        public boolean isExtensionOf() {
            return this.core$().is(ExtensionOfPassiveView.class);
        }

        @Override
        public void removeExtensionOf() {
            this.core$().removeFacet(ExtensionOfPassiveView.class);
        }

        @Override
        public LabeledComponent asLabeled() {
            return (LabeledComponent)this.a$(LabeledComponent.class);
        }

        @Override
        public LabeledComponent asLabeled(String label) {
            LabeledComponent newElement = (LabeledComponent)this.core$().addFacet(LabeledComponent.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        @Override
        public boolean isLabeled() {
            return this.core$().is(LabeledComponent.class);
        }

        @Override
        public void removeLabeled() {
            this.core$().removeFacet(LabeledComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer() {
            return (CollapseTriggererComponent)this.a$(CollapseTriggererComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer(CollapsibleBlock for$) {
            CollapseTriggererComponent newElement = (CollapseTriggererComponent)this.core$().addFacet(CollapseTriggererComponent.class);
            newElement.core$().set((Layer)newElement, "for", Collections.singletonList(for$));
            return newElement;
        }

        @Override
        public boolean isCollapseTriggerer() {
            return this.core$().is(CollapseTriggererComponent.class);
        }

        @Override
        public void removeCollapseTriggerer() {
            this.core$().removeFacet(CollapseTriggererComponent.class);
        }

        public EditableDate asEditable() {
            Layer as = this.a$(EditableDate.class);
            return as != null ? (EditableDate)as : (EditableDate)this.core$().addFacet(EditableDate.class);
        }

        public boolean isEditable() {
            return this.core$().is(EditableDate.class);
        }

        @Override
        public OptionComponent asOption() {
            Layer as = this.a$(OptionComponent.class);
            return as != null ? (OptionComponent)as : (OptionComponent)this.core$().addFacet(OptionComponent.class);
        }

        @Override
        public boolean isOption() {
            return this.core$().is(OptionComponent.class);
        }

        @Override
        public DynamicLoadedComponent asDynamicLoaded() {
            Layer as = this.a$(DynamicLoadedComponent.class);
            return as != null ? (DynamicLoadedComponent)as : (DynamicLoadedComponent)this.core$().addFacet(DynamicLoadedComponent.class);
        }

        @Override
        public boolean isDynamicLoaded() {
            return this.core$().is(DynamicLoadedComponent.class);
        }

        @Override
        public DecoratedDisplay asDecorated() {
            Layer as = this.a$(DecoratedDisplay.class);
            return as != null ? (DecoratedDisplay)as : (DecoratedDisplay)this.core$().addFacet(DecoratedDisplay.class);
        }

        @Override
        public boolean isDecorated() {
            return this.core$().is(DecoratedDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible() {
            return (AccessibleDisplay)this.a$(AccessibleDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible(List<String> parameters) {
            AccessibleDisplay newElement = (AccessibleDisplay)this.core$().addFacet(AccessibleDisplay.class);
            newElement.core$().set((Layer)newElement, "parameters", parameters);
            return newElement;
        }

        @Override
        public boolean isAccessible() {
            return this.core$().is(AccessibleDisplay.class);
        }

        @Override
        public void removeAccessible() {
            this.core$().removeFacet(AccessibleDisplay.class);
        }

        public FocusedDate asFocused() {
            Layer as = this.a$(FocusedDate.class);
            return as != null ? (FocusedDate)as : (FocusedDate)this.core$().addFacet(FocusedDate.class);
        }

        public boolean isFocused() {
            return this.core$().is(FocusedDate.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("pattern", new ArrayList<String>(Collections.singletonList(this.pattern)));
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            map.put("value", new ArrayList<Instant>(Collections.singletonList(this.value)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (Instant)InstantLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (Instant)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Mode {
            FromNow,
            ToNow,
            None;

        }
    }

    public static class Number
    extends Component
    implements Terminal {
        protected double value;
        protected String prefix;
        protected String suffix;

        public Number(Node node) {
            super(node);
        }

        public double value() {
            return this.value;
        }

        public String prefix() {
            return this.prefix;
        }

        public String suffix() {
            return this.suffix;
        }

        public Number value(double value) {
            this.value = value;
            return this;
        }

        public Number prefix(String value) {
            this.prefix = value;
            return this;
        }

        public Number suffix(String value) {
            this.suffix = value;
            return this;
        }

        public MultipleNumber asMultiple() {
            Layer as = this.a$(MultipleNumber.class);
            return as != null ? (MultipleNumber)as : (MultipleNumber)this.core$().addFacet(MultipleNumber.class);
        }

        public boolean isMultiple() {
            return this.core$().is(MultipleNumber.class);
        }

        public ReadonlyNumber asReadonly() {
            Layer as = this.a$(ReadonlyNumber.class);
            return as != null ? (ReadonlyNumber)as : (ReadonlyNumber)this.core$().addFacet(ReadonlyNumber.class);
        }

        public boolean isReadonly() {
            return this.core$().is(ReadonlyNumber.class);
        }

        public RequiredNumber asRequired() {
            Layer as = this.a$(RequiredNumber.class);
            return as != null ? (RequiredNumber)as : (RequiredNumber)this.core$().addFacet(RequiredNumber.class);
        }

        public boolean isRequired() {
            return this.core$().is(RequiredNumber.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf() {
            return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
            ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
            newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
            return newElement;
        }

        @Override
        public boolean isExtensionOf() {
            return this.core$().is(ExtensionOfPassiveView.class);
        }

        @Override
        public void removeExtensionOf() {
            this.core$().removeFacet(ExtensionOfPassiveView.class);
        }

        @Override
        public LabeledComponent asLabeled() {
            return (LabeledComponent)this.a$(LabeledComponent.class);
        }

        @Override
        public LabeledComponent asLabeled(String label) {
            LabeledComponent newElement = (LabeledComponent)this.core$().addFacet(LabeledComponent.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        @Override
        public boolean isLabeled() {
            return this.core$().is(LabeledComponent.class);
        }

        @Override
        public void removeLabeled() {
            this.core$().removeFacet(LabeledComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer() {
            return (CollapseTriggererComponent)this.a$(CollapseTriggererComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer(CollapsibleBlock for$) {
            CollapseTriggererComponent newElement = (CollapseTriggererComponent)this.core$().addFacet(CollapseTriggererComponent.class);
            newElement.core$().set((Layer)newElement, "for", Collections.singletonList(for$));
            return newElement;
        }

        @Override
        public boolean isCollapseTriggerer() {
            return this.core$().is(CollapseTriggererComponent.class);
        }

        @Override
        public void removeCollapseTriggerer() {
            this.core$().removeFacet(CollapseTriggererComponent.class);
        }

        public EditableNumber asEditable() {
            Layer as = this.a$(EditableNumber.class);
            return as != null ? (EditableNumber)as : (EditableNumber)this.core$().addFacet(EditableNumber.class);
        }

        public boolean isEditable() {
            return this.core$().is(EditableNumber.class);
        }

        @Override
        public OptionComponent asOption() {
            Layer as = this.a$(OptionComponent.class);
            return as != null ? (OptionComponent)as : (OptionComponent)this.core$().addFacet(OptionComponent.class);
        }

        @Override
        public boolean isOption() {
            return this.core$().is(OptionComponent.class);
        }

        @Override
        public DynamicLoadedComponent asDynamicLoaded() {
            Layer as = this.a$(DynamicLoadedComponent.class);
            return as != null ? (DynamicLoadedComponent)as : (DynamicLoadedComponent)this.core$().addFacet(DynamicLoadedComponent.class);
        }

        @Override
        public boolean isDynamicLoaded() {
            return this.core$().is(DynamicLoadedComponent.class);
        }

        @Override
        public DecoratedDisplay asDecorated() {
            Layer as = this.a$(DecoratedDisplay.class);
            return as != null ? (DecoratedDisplay)as : (DecoratedDisplay)this.core$().addFacet(DecoratedDisplay.class);
        }

        @Override
        public boolean isDecorated() {
            return this.core$().is(DecoratedDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible() {
            return (AccessibleDisplay)this.a$(AccessibleDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible(List<String> parameters) {
            AccessibleDisplay newElement = (AccessibleDisplay)this.core$().addFacet(AccessibleDisplay.class);
            newElement.core$().set((Layer)newElement, "parameters", parameters);
            return newElement;
        }

        @Override
        public boolean isAccessible() {
            return this.core$().is(AccessibleDisplay.class);
        }

        @Override
        public void removeAccessible() {
            this.core$().removeFacet(AccessibleDisplay.class);
        }

        public FocusedNumber asFocused() {
            Layer as = this.a$(FocusedNumber.class);
            return as != null ? (FocusedNumber)as : (FocusedNumber)this.core$().addFacet(FocusedNumber.class);
        }

        public boolean isFocused() {
            return this.core$().is(FocusedNumber.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("value", new ArrayList<Double>(Collections.singletonList(this.value)));
            map.put("prefix", new ArrayList<String>(Collections.singletonList(this.prefix)));
            map.put("suffix", new ArrayList<String>(Collections.singletonList(this.suffix)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Image
    extends Component
    implements Terminal {
        protected String value;
        protected String defaultValue;
        protected int mobileReduceFactor;

        public Image(Node node) {
            super(node);
        }

        public String value() {
            return this.value;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        public int mobileReduceFactor() {
            return this.mobileReduceFactor;
        }

        public Image value(String value) {
            this.value = value;
            return this;
        }

        public Image defaultValue(String value) {
            this.defaultValue = value;
            return this;
        }

        public Image mobileReduceFactor(int value) {
            this.mobileReduceFactor = value;
            return this;
        }

        public RelativeImage asRelative() {
            Layer as = this.a$(RelativeImage.class);
            return as != null ? (RelativeImage)as : (RelativeImage)this.core$().addFacet(RelativeImage.class);
        }

        public boolean isRelative() {
            return this.core$().is(RelativeImage.class);
        }

        public MultipleImage asMultiple() {
            Layer as = this.a$(MultipleImage.class);
            return as != null ? (MultipleImage)as : (MultipleImage)this.core$().addFacet(MultipleImage.class);
        }

        public boolean isMultiple() {
            return this.core$().is(MultipleImage.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf() {
            return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
            ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
            newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
            return newElement;
        }

        @Override
        public boolean isExtensionOf() {
            return this.core$().is(ExtensionOfPassiveView.class);
        }

        @Override
        public void removeExtensionOf() {
            this.core$().removeFacet(ExtensionOfPassiveView.class);
        }

        @Override
        public LabeledComponent asLabeled() {
            return (LabeledComponent)this.a$(LabeledComponent.class);
        }

        @Override
        public LabeledComponent asLabeled(String label) {
            LabeledComponent newElement = (LabeledComponent)this.core$().addFacet(LabeledComponent.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        @Override
        public boolean isLabeled() {
            return this.core$().is(LabeledComponent.class);
        }

        @Override
        public void removeLabeled() {
            this.core$().removeFacet(LabeledComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer() {
            return (CollapseTriggererComponent)this.a$(CollapseTriggererComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer(CollapsibleBlock for$) {
            CollapseTriggererComponent newElement = (CollapseTriggererComponent)this.core$().addFacet(CollapseTriggererComponent.class);
            newElement.core$().set((Layer)newElement, "for", Collections.singletonList(for$));
            return newElement;
        }

        @Override
        public boolean isCollapseTriggerer() {
            return this.core$().is(CollapseTriggererComponent.class);
        }

        @Override
        public void removeCollapseTriggerer() {
            this.core$().removeFacet(CollapseTriggererComponent.class);
        }

        public AbsoluteImage asAbsolute() {
            Layer as = this.a$(AbsoluteImage.class);
            return as != null ? (AbsoluteImage)as : (AbsoluteImage)this.core$().addFacet(AbsoluteImage.class);
        }

        public boolean isAbsolute() {
            return this.core$().is(AbsoluteImage.class);
        }

        public AvatarImage asAvatar() {
            return (AvatarImage)this.a$(AvatarImage.class);
        }

        public AvatarImage asAvatar(String text) {
            AvatarImage newElement = (AvatarImage)this.core$().addFacet(AvatarImage.class);
            newElement.core$().set((Layer)newElement, "text", Collections.singletonList(text));
            return newElement;
        }

        public boolean isAvatar() {
            return this.core$().is(AvatarImage.class);
        }

        public void removeAvatar() {
            this.core$().removeFacet(AvatarImage.class);
        }

        public ReadonlyImage asReadonly() {
            Layer as = this.a$(ReadonlyImage.class);
            return as != null ? (ReadonlyImage)as : (ReadonlyImage)this.core$().addFacet(ReadonlyImage.class);
        }

        public boolean isReadonly() {
            return this.core$().is(ReadonlyImage.class);
        }

        public RequiredImage asRequired() {
            Layer as = this.a$(RequiredImage.class);
            return as != null ? (RequiredImage)as : (RequiredImage)this.core$().addFacet(RequiredImage.class);
        }

        public boolean isRequired() {
            return this.core$().is(RequiredImage.class);
        }

        public EditableImage asEditable() {
            Layer as = this.a$(EditableImage.class);
            return as != null ? (EditableImage)as : (EditableImage)this.core$().addFacet(EditableImage.class);
        }

        public boolean isEditable() {
            return this.core$().is(EditableImage.class);
        }

        @Override
        public OptionComponent asOption() {
            Layer as = this.a$(OptionComponent.class);
            return as != null ? (OptionComponent)as : (OptionComponent)this.core$().addFacet(OptionComponent.class);
        }

        @Override
        public boolean isOption() {
            return this.core$().is(OptionComponent.class);
        }

        @Override
        public DynamicLoadedComponent asDynamicLoaded() {
            Layer as = this.a$(DynamicLoadedComponent.class);
            return as != null ? (DynamicLoadedComponent)as : (DynamicLoadedComponent)this.core$().addFacet(DynamicLoadedComponent.class);
        }

        @Override
        public boolean isDynamicLoaded() {
            return this.core$().is(DynamicLoadedComponent.class);
        }

        @Override
        public DecoratedDisplay asDecorated() {
            Layer as = this.a$(DecoratedDisplay.class);
            return as != null ? (DecoratedDisplay)as : (DecoratedDisplay)this.core$().addFacet(DecoratedDisplay.class);
        }

        @Override
        public boolean isDecorated() {
            return this.core$().is(DecoratedDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible() {
            return (AccessibleDisplay)this.a$(AccessibleDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible(List<String> parameters) {
            AccessibleDisplay newElement = (AccessibleDisplay)this.core$().addFacet(AccessibleDisplay.class);
            newElement.core$().set((Layer)newElement, "parameters", parameters);
            return newElement;
        }

        @Override
        public boolean isAccessible() {
            return this.core$().is(AccessibleDisplay.class);
        }

        @Override
        public void removeAccessible() {
            this.core$().removeFacet(AccessibleDisplay.class);
        }

        public FocusedImage asFocused() {
            Layer as = this.a$(FocusedImage.class);
            return as != null ? (FocusedImage)as : (FocusedImage)this.core$().addFacet(FocusedImage.class);
        }

        public boolean isFocused() {
            return this.core$().is(FocusedImage.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            map.put("defaultValue", new ArrayList<String>(Collections.singletonList(this.defaultValue)));
            map.put("mobileReduceFactor", new ArrayList<Integer>(Collections.singletonList(this.mobileReduceFactor)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("defaultValue")) {
                this.defaultValue = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mobileReduceFactor")) {
                this.mobileReduceFactor = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            } else if (name.equalsIgnoreCase("defaultValue")) {
                this.defaultValue = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mobileReduceFactor")) {
                this.mobileReduceFactor = (Integer)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class File
    extends Component
    implements Terminal {
        protected String value;

        public File(Node node) {
            super(node);
        }

        public String value() {
            return this.value;
        }

        public File value(String value) {
            this.value = value;
            return this;
        }

        public RelativeFile asRelative() {
            Layer as = this.a$(RelativeFile.class);
            return as != null ? (RelativeFile)as : (RelativeFile)this.core$().addFacet(RelativeFile.class);
        }

        public boolean isRelative() {
            return this.core$().is(RelativeFile.class);
        }

        public MultipleFile asMultiple() {
            Layer as = this.a$(MultipleFile.class);
            return as != null ? (MultipleFile)as : (MultipleFile)this.core$().addFacet(MultipleFile.class);
        }

        public boolean isMultiple() {
            return this.core$().is(MultipleFile.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf() {
            return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
            ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
            newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
            return newElement;
        }

        @Override
        public boolean isExtensionOf() {
            return this.core$().is(ExtensionOfPassiveView.class);
        }

        @Override
        public void removeExtensionOf() {
            this.core$().removeFacet(ExtensionOfPassiveView.class);
        }

        @Override
        public LabeledComponent asLabeled() {
            return (LabeledComponent)this.a$(LabeledComponent.class);
        }

        @Override
        public LabeledComponent asLabeled(String label) {
            LabeledComponent newElement = (LabeledComponent)this.core$().addFacet(LabeledComponent.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        @Override
        public boolean isLabeled() {
            return this.core$().is(LabeledComponent.class);
        }

        @Override
        public void removeLabeled() {
            this.core$().removeFacet(LabeledComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer() {
            return (CollapseTriggererComponent)this.a$(CollapseTriggererComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer(CollapsibleBlock for$) {
            CollapseTriggererComponent newElement = (CollapseTriggererComponent)this.core$().addFacet(CollapseTriggererComponent.class);
            newElement.core$().set((Layer)newElement, "for", Collections.singletonList(for$));
            return newElement;
        }

        @Override
        public boolean isCollapseTriggerer() {
            return this.core$().is(CollapseTriggererComponent.class);
        }

        @Override
        public void removeCollapseTriggerer() {
            this.core$().removeFacet(CollapseTriggererComponent.class);
        }

        public AbsoluteFile asAbsolute() {
            Layer as = this.a$(AbsoluteFile.class);
            return as != null ? (AbsoluteFile)as : (AbsoluteFile)this.core$().addFacet(AbsoluteFile.class);
        }

        public boolean isAbsolute() {
            return this.core$().is(AbsoluteFile.class);
        }

        public ReadonlyFile asReadonly() {
            Layer as = this.a$(ReadonlyFile.class);
            return as != null ? (ReadonlyFile)as : (ReadonlyFile)this.core$().addFacet(ReadonlyFile.class);
        }

        public boolean isReadonly() {
            return this.core$().is(ReadonlyFile.class);
        }

        public RequiredFile asRequired() {
            Layer as = this.a$(RequiredFile.class);
            return as != null ? (RequiredFile)as : (RequiredFile)this.core$().addFacet(RequiredFile.class);
        }

        public boolean isRequired() {
            return this.core$().is(RequiredFile.class);
        }

        public EditableFile asEditable() {
            Layer as = this.a$(EditableFile.class);
            return as != null ? (EditableFile)as : (EditableFile)this.core$().addFacet(EditableFile.class);
        }

        public boolean isEditable() {
            return this.core$().is(EditableFile.class);
        }

        @Override
        public OptionComponent asOption() {
            Layer as = this.a$(OptionComponent.class);
            return as != null ? (OptionComponent)as : (OptionComponent)this.core$().addFacet(OptionComponent.class);
        }

        @Override
        public boolean isOption() {
            return this.core$().is(OptionComponent.class);
        }

        @Override
        public DynamicLoadedComponent asDynamicLoaded() {
            Layer as = this.a$(DynamicLoadedComponent.class);
            return as != null ? (DynamicLoadedComponent)as : (DynamicLoadedComponent)this.core$().addFacet(DynamicLoadedComponent.class);
        }

        @Override
        public boolean isDynamicLoaded() {
            return this.core$().is(DynamicLoadedComponent.class);
        }

        @Override
        public DecoratedDisplay asDecorated() {
            Layer as = this.a$(DecoratedDisplay.class);
            return as != null ? (DecoratedDisplay)as : (DecoratedDisplay)this.core$().addFacet(DecoratedDisplay.class);
        }

        @Override
        public boolean isDecorated() {
            return this.core$().is(DecoratedDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible() {
            return (AccessibleDisplay)this.a$(AccessibleDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible(List<String> parameters) {
            AccessibleDisplay newElement = (AccessibleDisplay)this.core$().addFacet(AccessibleDisplay.class);
            newElement.core$().set((Layer)newElement, "parameters", parameters);
            return newElement;
        }

        @Override
        public boolean isAccessible() {
            return this.core$().is(AccessibleDisplay.class);
        }

        @Override
        public void removeAccessible() {
            this.core$().removeFacet(AccessibleDisplay.class);
        }

        public FocusedFile asFocused() {
            Layer as = this.a$(FocusedFile.class);
            return as != null ? (FocusedFile)as : (FocusedFile)this.core$().addFacet(FocusedFile.class);
        }

        public boolean isFocused() {
            return this.core$().is(FocusedFile.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Text
    extends Component
    implements Terminal {
        protected Mode mode;
        protected String value;
        protected String prefix;
        protected String suffix;

        public Text(Node node) {
            super(node);
        }

        public Mode mode() {
            return this.mode;
        }

        public String value() {
            return this.value;
        }

        public String prefix() {
            return this.prefix;
        }

        public String suffix() {
            return this.suffix;
        }

        public Text mode(Mode value) {
            this.mode = value;
            return this;
        }

        public Text value(String value) {
            this.value = value;
            return this;
        }

        public Text prefix(String value) {
            this.prefix = value;
            return this;
        }

        public Text suffix(String value) {
            this.suffix = value;
            return this;
        }

        public MultipleText asMultiple() {
            Layer as = this.a$(MultipleText.class);
            return as != null ? (MultipleText)as : (MultipleText)this.core$().addFacet(MultipleText.class);
        }

        public boolean isMultiple() {
            return this.core$().is(MultipleText.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf() {
            return (ExtensionOfPassiveView)this.a$(ExtensionOfPassiveView.class);
        }

        @Override
        public ExtensionOfPassiveView asExtensionOf(PassiveView parentView) {
            ExtensionOfPassiveView newElement = (ExtensionOfPassiveView)this.core$().addFacet(ExtensionOfPassiveView.class);
            newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
            return newElement;
        }

        @Override
        public boolean isExtensionOf() {
            return this.core$().is(ExtensionOfPassiveView.class);
        }

        @Override
        public void removeExtensionOf() {
            this.core$().removeFacet(ExtensionOfPassiveView.class);
        }

        @Override
        public LabeledComponent asLabeled() {
            return (LabeledComponent)this.a$(LabeledComponent.class);
        }

        @Override
        public LabeledComponent asLabeled(String label) {
            LabeledComponent newElement = (LabeledComponent)this.core$().addFacet(LabeledComponent.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        @Override
        public boolean isLabeled() {
            return this.core$().is(LabeledComponent.class);
        }

        @Override
        public void removeLabeled() {
            this.core$().removeFacet(LabeledComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer() {
            return (CollapseTriggererComponent)this.a$(CollapseTriggererComponent.class);
        }

        @Override
        public CollapseTriggererComponent asCollapseTriggerer(CollapsibleBlock for$) {
            CollapseTriggererComponent newElement = (CollapseTriggererComponent)this.core$().addFacet(CollapseTriggererComponent.class);
            newElement.core$().set((Layer)newElement, "for", Collections.singletonList(for$));
            return newElement;
        }

        @Override
        public boolean isCollapseTriggerer() {
            return this.core$().is(CollapseTriggererComponent.class);
        }

        @Override
        public void removeCollapseTriggerer() {
            this.core$().removeFacet(CollapseTriggererComponent.class);
        }

        public HighlightedText asHighlighted() {
            return (HighlightedText)this.a$(HighlightedText.class);
        }

        public HighlightedText asHighlighted(String textColor, String backgroundColor) {
            HighlightedText newElement = (HighlightedText)this.core$().addFacet(HighlightedText.class);
            newElement.core$().set((Layer)newElement, "textColor", Collections.singletonList(textColor));
            newElement.core$().set((Layer)newElement, "backgroundColor", Collections.singletonList(backgroundColor));
            return newElement;
        }

        public boolean isHighlighted() {
            return this.core$().is(HighlightedText.class);
        }

        public void removeHighlighted() {
            this.core$().removeFacet(HighlightedText.class);
        }

        public CodeText asCode() {
            return (CodeText)this.a$(CodeText.class);
        }

        public CodeText asCode(CodeLanguage language) {
            CodeText newElement = (CodeText)this.core$().addFacet(CodeText.class);
            newElement.core$().set((Layer)newElement, "language", Collections.singletonList(language));
            return newElement;
        }

        public boolean isCode() {
            return this.core$().is(CodeText.class);
        }

        public void removeCode() {
            this.core$().removeFacet(CodeText.class);
        }

        public ReadonlyText asReadonly() {
            Layer as = this.a$(ReadonlyText.class);
            return as != null ? (ReadonlyText)as : (ReadonlyText)this.core$().addFacet(ReadonlyText.class);
        }

        public boolean isReadonly() {
            return this.core$().is(ReadonlyText.class);
        }

        public RequiredText asRequired() {
            Layer as = this.a$(RequiredText.class);
            return as != null ? (RequiredText)as : (RequiredText)this.core$().addFacet(RequiredText.class);
        }

        public boolean isRequired() {
            return this.core$().is(RequiredText.class);
        }

        public EditableText asEditable() {
            Layer as = this.a$(EditableText.class);
            return as != null ? (EditableText)as : (EditableText)this.core$().addFacet(EditableText.class);
        }

        public boolean isEditable() {
            return this.core$().is(EditableText.class);
        }

        @Override
        public OptionComponent asOption() {
            Layer as = this.a$(OptionComponent.class);
            return as != null ? (OptionComponent)as : (OptionComponent)this.core$().addFacet(OptionComponent.class);
        }

        @Override
        public boolean isOption() {
            return this.core$().is(OptionComponent.class);
        }

        @Override
        public DynamicLoadedComponent asDynamicLoaded() {
            Layer as = this.a$(DynamicLoadedComponent.class);
            return as != null ? (DynamicLoadedComponent)as : (DynamicLoadedComponent)this.core$().addFacet(DynamicLoadedComponent.class);
        }

        @Override
        public boolean isDynamicLoaded() {
            return this.core$().is(DynamicLoadedComponent.class);
        }

        @Override
        public DecoratedDisplay asDecorated() {
            Layer as = this.a$(DecoratedDisplay.class);
            return as != null ? (DecoratedDisplay)as : (DecoratedDisplay)this.core$().addFacet(DecoratedDisplay.class);
        }

        @Override
        public boolean isDecorated() {
            return this.core$().is(DecoratedDisplay.class);
        }

        public MemoText asMemo() {
            Layer as = this.a$(MemoText.class);
            return as != null ? (MemoText)as : (MemoText)this.core$().addFacet(MemoText.class);
        }

        public boolean isMemo() {
            return this.core$().is(MemoText.class);
        }

        @Override
        public AccessibleDisplay asAccessible() {
            return (AccessibleDisplay)this.a$(AccessibleDisplay.class);
        }

        @Override
        public AccessibleDisplay asAccessible(List<String> parameters) {
            AccessibleDisplay newElement = (AccessibleDisplay)this.core$().addFacet(AccessibleDisplay.class);
            newElement.core$().set((Layer)newElement, "parameters", parameters);
            return newElement;
        }

        @Override
        public boolean isAccessible() {
            return this.core$().is(AccessibleDisplay.class);
        }

        @Override
        public void removeAccessible() {
            this.core$().removeFacet(AccessibleDisplay.class);
        }

        public PasswordText asPassword() {
            Layer as = this.a$(PasswordText.class);
            return as != null ? (PasswordText)as : (PasswordText)this.core$().addFacet(PasswordText.class);
        }

        public boolean isPassword() {
            return this.core$().is(PasswordText.class);
        }

        public FocusedText asFocused() {
            Layer as = this.a$(FocusedText.class);
            return as != null ? (FocusedText)as : (FocusedText)this.core$().addFacet(FocusedText.class);
        }

        public boolean isFocused() {
            return this.core$().is(FocusedText.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            map.put("prefix", new ArrayList<String>(Collections.singletonList(this.prefix)));
            map.put("suffix", new ArrayList<String>(Collections.singletonList(this.suffix)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Mode {
            Uppercase,
            Lowercase,
            Capitalize,
            Normal;

        }
    }

    public class Clear {
        public void text(Predicate<Text> filter) {
            new ArrayList<Text>(DataComponents.this.textList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void file(Predicate<File> filter) {
            new ArrayList<File>(DataComponents.this.fileList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void image(Predicate<Image> filter) {
            new ArrayList<Image>(DataComponents.this.imageList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void number(Predicate<Number> filter) {
            new ArrayList<Number>(DataComponents.this.numberList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void date(Predicate<Date> filter) {
            new ArrayList<Date>(DataComponents.this.dateList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void location(Predicate<Location> filter) {
            new ArrayList<Location>(DataComponents.this.locationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Text text() {
            Text newElement = (Text)DataComponents.this.core$().graph().concept(Text.class).createNode(this.name, DataComponents.this.core$()).as(Text.class);
            return newElement;
        }

        public File file() {
            File newElement = (File)DataComponents.this.core$().graph().concept(File.class).createNode(this.name, DataComponents.this.core$()).as(File.class);
            return newElement;
        }

        public Image image() {
            Image newElement = (Image)DataComponents.this.core$().graph().concept(Image.class).createNode(this.name, DataComponents.this.core$()).as(Image.class);
            return newElement;
        }

        public Number number() {
            Number newElement = (Number)DataComponents.this.core$().graph().concept(Number.class).createNode(this.name, DataComponents.this.core$()).as(Number.class);
            return newElement;
        }

        public Date date() {
            Date newElement = (Date)DataComponents.this.core$().graph().concept(Date.class).createNode(this.name, DataComponents.this.core$()).as(Date.class);
            return newElement;
        }

        public Location location() {
            Location newElement = (Location)DataComponents.this.core$().graph().concept(Location.class).createNode(this.name, DataComponents.this.core$()).as(Location.class);
            return newElement;
        }
    }
}

