/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;

public class PageRenderer
extends ActionRenderer {
    private final Settings settings;
    private final AbstractUIService.Resource resource;
    private final UIService service;

    public PageRenderer(Settings settings, AbstractUIService.Resource resource) {
        super(settings, "ui");
        this.settings = settings;
        this.resource = resource;
        this.service = (UIService)resource.core$().ownerAs(UIService.class);
    }

    @Override
    public void render() {
        FrameBuilder builder = new FrameBuilder().add("action").add("ui");
        builder.add("name", (Object)this.resource.name$());
        builder.add("uiService", (Object)((UIService)this.resource.core$().ownerAs(UIService.class)).name$());
        builder.add("package", (Object)this.packageName());
        builder.add("box", (Object)this.boxName());
        builder.add("importTemplates", (Object)this.packageName());
        builder.add("component", (Object)this.componentFrame());
        builder.add("parameter", (Object)this.parameters());
        this.service.useList().forEach(use -> builder.add("usedAppUrl", (Object)new FrameBuilder(new String[]{"usedAppUrl"}).add(this.isCustom(use.url()) ? "custom" : "standard").add("value", (Object)(this.isCustom(use.url()) ? this.customValue(use.url()) : use.url()))).toFrame());
        if (this.service.favicon() != null) {
            builder.add("favicon", (Object)this.service.favicon());
        } else if (this.service.title() != null) {
            builder.add("title", (Object)this.service.title());
        }
        this.settings.classes().put(((Object)((Object)this.resource)).getClass().getSimpleName() + "#" + this.firstUpperCase(this.resource.core$().name()), "actions." + this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)this.resource.name$())) + this.suffix());
        if (!this.alreadyRendered(this.src(), this.resource.name$())) {
            Commons.writeFrame(this.destinyPackage(this.src()), this.resource.name$() + this.suffix(), this.template().render((Object)builder.toFrame()));
        }
        Commons.writeFrame(this.destinyPackage(this.gen()), "Abstract" + this.firstUpperCase(this.resource.name$()) + this.suffix(), this.template().render((Object)builder.add("gen").toFrame()));
    }

    private FrameBuilder componentFrame() {
        return new FrameBuilder(new String[]{"component"}).add("value", (Object)KonosGraph.templateFor(this.resource).name$());
    }

    private FrameBuilder[] parameters() {
        List<String> parameters = Commons.extractUrlPathParameters(this.resource.path());
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add("type", (Object)"String").add("name", parameter)).toArray(FrameBuilder[]::new);
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private String customValue(String value) {
        return value != null ? value.substring(1, value.length() - 1) : "";
    }

    @Override
    protected File destinyPackage(File destiny) {
        return new File(destiny, CodeGenerationHelper.format("%spages", Target.Owner));
    }

    @Override
    protected String suffix() {
        return "Page";
    }
}

