/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.AccessibleDisplayActionRenderer;
import io.intino.konos.builder.codegeneration.services.ui.templates.ResourceTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.accessible.AccessibleDisplay;

public class AccessibleDisplayRenderer
extends UIRenderer {
    private final AccessibleDisplay display;

    public AccessibleDisplayRenderer(Settings settings, AccessibleDisplay display, Target target) {
        super(settings, target);
        this.display = display;
    }

    @Override
    public void render() {
        if (this.isRendered(this.display)) {
            return;
        }
        FrameBuilder builder = this.buildFrame().add("name", (Object)this.display.name$());
        builder.add("resource");
        builder.add(((Object)((Object)this.display)).getClass().getSimpleName());
        builder.add("parameter", (Object)this.parameters(this.display));
        if (this.target == Target.Owner) {
            Commons.writeFrame(CodeGenerationHelper.resourceFolder(this.gen(), this.target), CodeGenerationHelper.resourceFilename(this.display.name$(), "ProxyResource"), this.setup(new ResourceTemplate()).render((Object)builder.toFrame()));
        }
        new AccessibleDisplayActionRenderer(this.settings, this.display).execute();
        this.saveRendered(this.display);
    }

    private FrameBuilder[] parameters(AccessibleDisplay display) {
        return (FrameBuilder[])display.parameters().stream().map(parameter -> new FrameBuilder().add("parameter").add("name", parameter)).toArray(FrameBuilder[]::new);
    }
}

