/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components.other;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.SizedRenderer;
import io.intino.konos.model.graph.AbstractAnimated;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.animated.AnimatedBlock;
import io.intino.konos.model.graph.badge.BadgeBlock;
import io.intino.konos.model.graph.drawer.DrawerBlock;
import io.intino.konos.model.graph.option.OptionComponent;
import io.intino.konos.model.graph.rules.Spacing;
import io.intino.konos.model.graph.splitter.SplitterBlock;

public class BlockRenderer
extends SizedRenderer<Block> {
    public BlockRenderer(Settings settings, Block component, TemplateProvider provider, Target target) {
        super(settings, component, provider, target);
    }

    @Override
    public void fill(FrameBuilder builder) {
        if (((Block)this.element).isConditional()) {
            builder.add("conditional");
        }
        this.addBinding(builder);
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        this.addSpacing(result);
        this.addLayout(result);
        this.addPaper(result);
        this.addBadge(result);
        this.addParallax(result);
        this.addDrawer(result);
        this.addTransition(result);
        this.addSplitter(result);
        if (((Block)this.element).hidden() != null && ((Block)this.element).hidden() != Block.Hidden.Never) {
            result.add("hidden", (Object)((Block)this.element).hidden().name());
        }
        if (((Block)this.element).isCollapsible()) {
            result.add("collapsible", (Object)"true");
        }
        return result;
    }

    private void addSpacing(FrameBuilder builder) {
        if (((Block)this.element).spacing() != Spacing.None) {
            builder.add("spacing", (Object)((Block)this.element).spacing().value());
        }
    }

    private void addLayout(FrameBuilder builder) {
        String[] layout = (String[])((Block)this.element).layout().stream().map(l -> l.name().toLowerCase()).toArray(String[]::new);
        builder.add("layout", (Object)layout);
    }

    private void addPaper(FrameBuilder builder) {
        if (!((Block)this.element).isPaper()) {
            return;
        }
        builder.add("paper", (Object)"paper");
    }

    private void addBadge(FrameBuilder builder) {
        if (!((Block)this.element).isBadge()) {
            return;
        }
        BadgeBlock badgeBlock = ((Block)this.element).asBadge();
        FrameBuilder badgeFrame = new FrameBuilder(new String[]{"badge"});
        if (badgeBlock.value() != -1) {
            badgeFrame.add("value", (Object)badgeBlock.value());
        }
        if (badgeBlock.max() != -1) {
            badgeFrame.add("max", (Object)badgeBlock.max());
        }
        if (badgeBlock.showZero()) {
            badgeFrame.add("showZero", (Object)true);
        }
        badgeFrame.add("mode", (Object)badgeBlock.mode().name());
        builder.add("badge", (Object)badgeFrame);
    }

    private void addParallax(FrameBuilder builder) {
        if (!((Block)this.element).isParallax()) {
            return;
        }
        String background = ((Block)this.element).asParallax().background();
        if (background == null || background.isEmpty()) {
            return;
        }
        builder.add("background", (Object)this.resourceMethodFrame("background", background));
    }

    private void addDrawer(FrameBuilder builder) {
        if (!((Block)this.element).isDrawer()) {
            return;
        }
        DrawerBlock drawerBlock = ((Block)this.element).asDrawer();
        FrameBuilder drawerFrame = new FrameBuilder(new String[]{"drawer"});
        drawerFrame.add("position", (Object)drawerBlock.position().name());
        drawerFrame.add("variant", (Object)drawerBlock.variant().name());
        builder.add("drawer", (Object)drawerFrame);
    }

    private void addTransition(FrameBuilder builder) {
        if (!((Block)this.element).isAnimated()) {
            return;
        }
        AnimatedBlock block = ((Block)this.element).asAnimated();
        AbstractAnimated.Transition transition = block.transitionList().size() > 0 ? block.transition(0) : null;
        builder.add("mode", (Object)block.mode().name());
        builder.add("transitionDirection", (Object)(transition != null ? transition.direction().name() : "Right"));
        builder.add("transitionDuration", (Object)(transition != null ? transition.duration() : 500));
    }

    private void addSplitter(FrameBuilder builder) {
        if (!((Block)this.element).isSplitter()) {
            return;
        }
        SplitterBlock block = ((Block)this.element).asSplitter();
        builder.add("splitMobileLabel", (Object)block.splitMobileLabel());
    }

    private void addBinding(FrameBuilder builder) {
        if (!((Block)this.element).isConditional()) {
            return;
        }
        OptionComponent option = ((Block)this.element).asConditional().selected();
        if (option == null) {
            return;
        }
        OtherComponents.Selector selector = (OtherComponents.Selector)option.core$().ownerAs(OtherComponents.Selector.class);
        builder.add("binding", (Object)new FrameBuilder(new String[]{"binding"}).add("name", (Object)this.nameOf(this.element)).add("selector", (Object)selector.name$()).add("option", (Object)option.name$()));
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("block", "");
    }
}

