/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components.data;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.code.datacomponents.CodeText;
import io.intino.konos.model.graph.editable.datacomponents.EditableText;
import io.intino.konos.model.graph.highlighted.datacomponents.HighlightedText;
import org.apache.commons.lang.StringEscapeUtils;

public class TextRenderer
extends ComponentRenderer<DataComponents.Text> {
    public TextRenderer(Settings settings, DataComponents.Text component, TemplateProvider provider, Target target) {
        super(settings, component, provider, target);
    }

    @Override
    public void fill(FrameBuilder builder) {
        if (((DataComponents.Text)this.element).prefix() != null) {
            builder.add("prefix", (Object)((DataComponents.Text)this.element).prefix());
        }
        if (((DataComponents.Text)this.element).suffix() != null) {
            builder.add("suffix", (Object)((DataComponents.Text)this.element).suffix());
        }
        if (((DataComponents.Text)this.element).isCode()) {
            FrameBuilder codeFrame = new FrameBuilder(new String[]{CodeText.class.getSimpleName()});
            if (((DataComponents.Text)this.element).asCode().value() != null) {
                codeFrame.add("value", (Object)this.escape(((DataComponents.Text)this.element).asCode().value()));
            }
            builder.add("code", (Object)codeFrame);
        }
    }

    private String escape(String value) {
        return StringEscapeUtils.escapeHtml((String)value).trim().replaceAll("\"", "'");
    }

    @Override
    public FrameBuilder properties() {
        EditableText editableText;
        FrameBuilder result = super.properties();
        this.addHighlight(result);
        result.add("mode", (Object)((DataComponents.Text)this.element).mode().name().toLowerCase());
        if (((DataComponents.Text)this.element).isPassword()) {
            result.add("type", (Object)"password");
        }
        if (((DataComponents.Text)this.element).isReadonly()) {
            result.add("readonly", (Object)((DataComponents.Text)this.element).isReadonly());
        }
        if (((DataComponents.Text)this.element).isFocused()) {
            result.add("focused", (Object)((DataComponents.Text)this.element).isFocused());
        }
        if (((DataComponents.Text)this.element).isCode()) {
            result.add(CodeText.class.getSimpleName());
            result.add("language", (Object)((DataComponents.Text)this.element).asCode().language().name());
        }
        if (((DataComponents.Text)this.element).value() != null) {
            String value = ((DataComponents.Text)this.element).isCode() ? ((DataComponents.Text)this.element).value().replaceAll("\\n", "").replaceAll("\"", "\\\\\"") : ((DataComponents.Text)this.element).value();
            result.add("defaultValue", (Object)value);
        }
        if (((DataComponents.Text)this.element).isEditable() && (editableText = ((DataComponents.Text)this.element).asEditable()).placeHolder() != null) {
            result.add("placeholder", (Object)editableText.placeHolder());
        }
        return result;
    }

    private void addHighlight(FrameBuilder result) {
        if (!((DataComponents.Text)this.element).isHighlighted()) {
            return;
        }
        HighlightedText highlight = ((DataComponents.Text)this.element).asHighlighted();
        FrameBuilder highlightedFrame = new FrameBuilder(new String[]{"highlighted"}).add("text", (Object)highlight.textColor()).add("background", (Object)highlight.backgroundColor());
        result.add("highlighted", (Object)highlightedFrame);
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("text", "");
    }
}

