/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.messaging;

import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingServiceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Workflow;
import io.intino.konos.model.graph.messaging.MessagingService;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class MessagingServiceRenderer
extends Renderer {
    private final List<MessagingService> services;
    private final Workflow workflow;

    public MessagingServiceRenderer(Settings settings, KonosGraph graph) {
        super(settings, Target.Owner);
        this.services = graph.messagingServiceList();
        this.workflow = graph.workflow();
    }

    @Override
    public void render() {
        this.services.forEach(this::processService);
    }

    private void processService(MessagingService service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"jms"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("businessUnit", (Object)(this.workflow != null ? this.workflow.businessUnit() : "")).add("model", (Object)service.subscriptionModel().name()).add("request", (Object)this.processRequests(service.requestList(), service.domain(), service.subscriptionModel().name())).add("notification", (Object)this.processNotifications(service.notificationList(), service.subscriptionModel().name()));
        if (service.requestList().stream().anyMatch(MessagingService.Request::isProcessTrigger)) {
            builder.add("hasProcess", (Object)";");
        }
        if (!service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        Commons.writeFrame(this.gen(), this.nameOf(service), this.template().render((Object)builder.toFrame()));
    }

    @NotNull
    private String nameOf(MessagingService service) {
        String string = ((Formatter)StringFormatters.get((Locale)Locale.getDefault()).get("firstuppercase")).format((Object)service.name$()).toString() + "Service";
        if (string == null) {
            MessagingServiceRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    private Frame[] processRequests(List<MessagingService.Request> requests, String domain, String subscriptionModel) {
        return (Frame[])requests.stream().map(request -> this.processRequest((MessagingService.Request)((Object)request), domain, subscriptionModel)).toArray(Frame[]::new);
    }

    private Frame processRequest(MessagingService.Request request, String domain, String subscriptionModel) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("package", (Object)this.packageName()).add("model", (Object)subscriptionModel).add("parameter", (Object)this.parameters(request.parameterList())).add("queue", (Object)Formatters.customize("queue", "service." + domain + "." + request.path()));
        if (request.isProcessTrigger()) {
            builder.add("process").add("process", (Object)request.asProcessTrigger().process().name$());
        }
        return builder.toFrame();
    }

    private Frame[] processNotifications(List<MessagingService.Notification> notifications, String subscriptionModel) {
        return (Frame[])notifications.stream().map(notification -> this.processNotification((MessagingService.Notification)((Object)notification), subscriptionModel)).toArray(Frame[]::new);
    }

    private Frame processNotification(MessagingService.Notification notification, String subscriptionModel) {
        return new FrameBuilder(new String[]{"notification"}).add("name", (Object)notification.name$()).add("package", (Object)this.packageName()).add("queue", (Object)Formatters.customize("queue", notification.path())).add("model", (Object)subscriptionModel).add("parameter", (Object)this.parameters(notification.parameterList())).add("returnMessageType", (Object)this.messageType(notification.parameterList())).toFrame();
    }

    private Template template() {
        return Formatters.customize(new MessagingServiceTemplate());
    }

    private String messageType(List<Parameter> parameters) {
        return parameters.stream().anyMatch(Parameter::isFile) ? "Bytes" : "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/messaging/MessagingServiceRenderer", "nameOf"));
    }
}

