/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.messagehub;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.messagehub.MessageHubTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHub;
import io.intino.konos.model.graph.realtime.RealtimeMounter;
import java.io.File;

public class MessageHubRenderer {
    private final Settings settings;
    private final KonosGraph graph;
    private final File sourceDirectory;
    private final File genDirectory;

    public MessageHubRenderer(Settings settings, KonosGraph graph) {
        this.graph = graph;
        this.settings = settings;
        this.sourceDirectory = settings.src(Target.Owner);
        this.genDirectory = settings.gen(Target.Owner);
    }

    public void execute() {
        File destination;
        MessageHub messageHub = this.graph.messageHub();
        if (messageHub == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"messageHub"}).add("box", (Object)this.settings.boxName()).add("package", (Object)this.settings.packageName());
        if (messageHub.isJmsBus()) {
            builder.add("jms");
        }
        this.graph.realtimeMounterList().forEach(mounter -> builder.add("mounter", (Object)this.frameOf((RealtimeMounter)((Object)mounter))));
        this.settings.classes().put("MessageHub", "MessageHub");
        File file = destination = messageHub.isJmsBus() ? this.genDirectory : this.sourceDirectory;
        if (!Commons.javaFile(destination, "MessageHub").exists()) {
            Commons.writeFrame(destination, "MessageHub", Formatters.customize(new MessageHubTemplate()).render((Object)builder.toFrame()));
        }
    }

    private FrameBuilder frameOf(RealtimeMounter mounter) {
        return new FrameBuilder(new String[]{"mounter"}).add("package", (Object)this.settings.packageName()).add("name", (Object)mounter.name$()).add("source", mounter.sourceList().stream().map(RealtimeMounter.Source::channel).toArray(String[]::new));
    }
}

