/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.cache;

import io.intino.konos.builder.codegeneration.cache.ElementCache;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.stores.FileSystemStore;
import io.intino.tara.magritte.utils.StoreAuditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheReader
extends HashMap<String, Integer> {
    private final File folder;
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");

    public CacheReader(File folder) {
        this.folder = folder;
    }

    public ElementCache load(KonosGraph graph) {
        return this.load(graph, null);
    }

    public ElementCache load(KonosGraph graph, Stash konosStash) {
        StoreAuditor auditor = this.loadAuditor(graph, konosStash);
        return this.loadCacheFile(auditor);
    }

    private StoreAuditor loadAuditor(KonosGraph graph, Stash konosStash) {
        StoreAuditor auditor = new StoreAuditor(this.store(konosStash));
        Arrays.stream(graph.core$().openedStashes()).forEach(arg_0 -> ((StoreAuditor)auditor).trace(arg_0));
        return auditor;
    }

    @NotNull
    private FileSystemStore store(final Stash konosStash) {
        return new FileSystemStore(this.folder){

            public Stash stashFrom(String path) {
                if (path.equalsIgnoreCase("konos.stash")) {
                    return konosStash;
                }
                return super.stashFrom(path);
            }
        };
    }

    private ElementCache loadCacheFile(StoreAuditor auditor) {
        try {
            File cacheFile = new File(this.folder + "/.cache");
            if (!cacheFile.exists()) {
                return new ElementCache(auditor);
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(cacheFile));
            Map<String, String> marks = properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
            return new ElementCache(auditor, marks);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            return null;
        }
    }
}

