/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.DisplaysManifestTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DisplaysManifestRenderer
extends UIRenderer {
    private final UIService service;
    private final Set<String> renderedDisplays = new HashSet<String>();

    protected DisplaysManifestRenderer(Settings settings, UIService service) {
        super(settings, Target.Accessor);
        this.service = service;
    }

    @Override
    public void render() {
        FrameBuilder result = new FrameBuilder(new String[]{"manifest"});
        Set<Display> displays = this.service.graph().rootDisplays().stream().filter(this::isBaseType).collect(Collectors.toSet());
        Set<PassiveView> baseDisplays = this.baseDisplays(displays);
        baseDisplays.forEach(d -> this.renderDisplay(d, result));
        displays.stream().filter(d -> !this.renderedDisplays.contains(d.core$().id())).forEach(d -> this.renderDisplay(d, result));
        Commons.write(new File(this.gen() + File.separator + "Displays.js").toPath(), this.setup(new DisplaysManifestTemplate()).render((Object)result.toFrame()));
    }

    private Set<PassiveView> baseDisplays(Set<Display> displays) {
        return displays.stream().filter(Display::isExtensionOf).map(this::baseDisplays).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<PassiveView> baseDisplays(PassiveView view) {
        LinkedHashSet<PassiveView> result = new LinkedHashSet<PassiveView>();
        if (view.isExtensionOf()) {
            PassiveView passiveView = view.asExtensionOf().parentView();
            result.addAll(this.baseDisplays(passiveView));
        }
        result.add(view);
        return result;
    }

    private <D extends PassiveView> void renderDisplay(D display, FrameBuilder builder) {
        builder.add("display", (Object)this.display(display));
        this.renderedDisplays.add(display.core$().id());
    }

    private <D extends PassiveView> Frame display(D display) {
        FrameBuilder result = new FrameBuilder(new String[]{"display", this.typeOf(display)});
        result.add("name", (Object)this.nameOf(display));
        result.add("directory", (Object)(ElementHelper.isRoot(display) ? "src" : "gen"));
        return result.toFrame();
    }
}

