/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.AppTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.PassiveViewTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.WebPackTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.utils.ProjectUtil;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;

public class AppRenderer
extends UIRenderer {
    private final UIService service;

    protected AppRenderer(Settings settings, UIService service) {
        super(settings, Target.Accessor);
        this.service = service;
    }

    @Override
    public void render() {
        this.writeApp();
        this.writePassiveView();
        this.writeWebPack();
    }

    private void writeApp() {
        CodeGenerationHelper.createIfNotExists(new File(this.gen() + File.separator + "apps"));
        this.service.resourceList().forEach(r -> {
            FrameBuilder builder = new FrameBuilder(new String[]{"app"});
            builder.add("page", (Object)new FrameBuilder(new String[]{"page"}).add("value", (Object)r.name$()).toFrame());
            Commons.write(new File(this.gen() + File.separator + "apps" + File.separator + Formatters.firstUpperCase(r.name$()) + ".js").toPath(), this.setup(new AppTemplate()).render((Object)builder.toFrame()));
        });
    }

    private void writePassiveView() {
        PassiveViewTemplate template = new PassiveViewTemplate();
        File notifiersFile = CodeGenerationHelper.createIfNotExists(new File(this.gen() + "/displays/notifiers"));
        File requestersFile = CodeGenerationHelper.createIfNotExists(new File(this.gen() + "/displays/requesters"));
        Commons.write(new File(notifiersFile + File.separator + "Notifier.js").toPath(), template.render(new FrameBuilder(new String[]{"notifier"})));
        Commons.write(new File(requestersFile + File.separator + "Requester.js").toPath(), template.render(new FrameBuilder(new String[]{"requester"})));
    }

    private void writeWebPack() {
        WebPackTemplate template = new WebPackTemplate();
        FrameBuilder builder = new FrameBuilder(new String[]{"webpack"});
        builder.add("outDirectory", (Object)new File(ProjectUtil.moduleOutDirectory(this.settings.module())).getParent());
        builder.add("exclude", (Object)this.alexandriaFrame("exclude"));
        builder.add("alias", (Object)this.alexandriaFrame("alias"));
        builder.add("webModuleName", (Object)(this.settings.webModule() != null ? this.settings.webModule().getName() : ""));
        if (ProjectUtil.isAlexandria(this.project())) {
            builder.add("alexandriaProject", (Object)"true");
        }
        this.service.resourceList().forEach(r -> builder.add("page", (Object)new FrameBuilder(new String[]{"page"}).add("value", (Object)r.name$()).toFrame()));
        Commons.write(new File(this.root() + File.separator + "webpack.config.js").toPath(), this.setup(template).render((Object)builder.toFrame()));
    }

    private FrameBuilder alexandriaFrame(String name) {
        FrameBuilder result = new FrameBuilder(new String[]{name});
        if (ProjectUtil.isAlexandria(this.project())) {
            result.add("alexandriaProject");
        }
        return result;
    }
}

