/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.BoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.dsl.Meta;
import io.intino.tara.dsl.Proteo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class BoxRenderer
extends Renderer {
    private final KonosGraph graph;
    private boolean isTara;

    BoxRenderer(Settings settings, KonosGraph graph, boolean isTara) {
        super(settings, Target.Owner);
        this.graph = graph;
        this.isTara = isTara;
    }

    @Override
    public void render() {
        if (this.configuration() == null) {
            return;
        }
        String name = this.settings.boxName();
        if (Commons.javaFile(this.src(), StringHelper.snakeCaseToCamelCase((String)name) + "Box").exists()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"Box"}).add("package", (Object)this.packageName()).add("name", (Object)name);
        if (this.isTara) {
            builder.add("tara", (Object)this.fillTara());
        }
        DumbService.getInstance((Project)this.module().getProject()).setAlternativeResolveEnabled(true);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.module().getProject());
        if (facade.findClass("io.intino.konos.server.ui.services.AuthService", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module())) != null) {
            builder.add("rest", (Object)name);
        }
        if (this.hasAuthenticatedApis()) {
            builder.add("authenticationValidator", (Object)new FrameBuilder().add("type", (Object)"Basic"));
        }
        DumbService.getInstance((Project)this.module().getProject()).setAlternativeResolveEnabled(false);
        Commons.writeFrame(this.src(), StringHelper.snakeCaseToCamelCase((String)name) + "Box", this.template().render((Object)builder.toFrame()));
    }

    private boolean hasAuthenticatedApis() {
        return this.graph.rESTServiceList().stream().anyMatch(restService -> restService.authenticatedWithToken() != null);
    }

    private Frame fillTara() {
        FrameBuilder builder = new FrameBuilder();
        Configuration configuration = this.configuration();
        builder.add("name", (Object)this.settings.boxName());
        if (configuration.outLanguage() != null) {
            builder.add("outDSL", (Object)configuration.outLanguage());
        }
        builder.add("wrapper", (Object)this.dsls());
        return builder.toFrame();
    }

    private String[] dsls() {
        Configuration configuration = this.configuration();
        ArrayList<CallSite> dsls = new ArrayList<CallSite>();
        for (Configuration.LanguageLibrary lang : configuration.languages()) {
            if (Meta.class.getSimpleName().equals(lang.name()) || Proteo.class.getSimpleName().equals(lang.name())) continue;
            String genPackage = lang.generationPackage();
            dsls.add((CallSite)((Object)((String)(genPackage == null ? "" : genPackage.toLowerCase() + ".") + Formatters.firstUpperCase(lang.name()))));
        }
        if (configuration.level() != Configuration.Level.Solution) {
            dsls.add((CallSite)((Object)(configuration.workingPackage().toLowerCase() + "." + Formatters.firstUpperCase(configuration.outLanguage()))));
        }
        return dsls.toArray(new String[0]);
    }

    private Template template() {
        return Formatters.customize(new BoxTemplate());
    }
}

