/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.ParameterPublisher;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Settings;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Datalake;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHub;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.jmsbus.JmsBusMessageHub;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.messaging.MessagingService;
import io.intino.konos.model.graph.realtime.RealtimeMounter;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.sshmirrored.SshMirroredDatalake;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbstractBoxRenderer
extends Renderer {
    private final KonosGraph graph;
    private final Configuration configuration;
    private final boolean hasModel;
    private final Set<String> konosParameters;

    AbstractBoxRenderer(Settings settings, KonosGraph graph, boolean hasModel) {
        super(settings, Target.Owner);
        this.graph = graph;
        this.configuration = this.module() != null ? TaraUtil.configurationOf((Module)this.module()) : null;
        this.hasModel = hasModel;
        this.konosParameters = new HashSet<String>();
        this.konosParameters.add("workspace");
    }

    @Override
    public void render() {
        FrameBuilder root = new FrameBuilder(new String[]{"box"});
        String boxName = this.settings.boxName();
        root.add("name", (Object)boxName).add("package", (Object)this.packageName());
        if (this.hasModel) {
            root.add("tara", (Object)boxName);
        }
        this.parent(root);
        this.services(root, boxName);
        this.sentinels(root, boxName);
        this.datalake(root);
        this.messageHub(root, boxName);
        this.workflow(root);
        if (this.hasAuthenticatedApis()) {
            root.add("authenticationValidator", (Object)new FrameBuilder().add("type", (Object)"Basic"));
        }
        this.graph.datamartList().forEach(d -> this.datamart(root, (Datamart)((Object)d)));
        Commons.writeFrame(this.settings.gen(Target.Owner), "AbstractBox", this.template().render((Object)root.toFrame()));
        this.notifyNewParameters();
    }

    Set<String> customParameters() {
        return this.konosParameters;
    }

    private void datamart(FrameBuilder root, Datamart datamart) {
        root.add("datamart", (Object)new FrameBuilder(new String[]{"datamart"}).add("name", (Object)datamart.name$()).add("value", (Object)datamart.path()));
    }

    private void notifyNewParameters() {
        new ParameterPublisher((LegioConfiguration)this.configuration).publish(this.konosParameters);
    }

    private void sentinels(FrameBuilder builder, String boxName) {
        if (!this.graph.sentinelList().isEmpty()) {
            builder.add("sentinel", (Object)new FrameBuilder(new String[]{"sentinel"}).add("configuration", (Object)boxName).toFrame());
        }
    }

    private void datalake(FrameBuilder root) {
        Datalake datalake = this.graph.datalake();
        if (datalake == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"datalake", datalake.isLocal() ? "Local" : "Mirror"});
        builder.add("package", (Object)this.packageName());
        builder.add("path", (Object)this.parameter(datalake.path(), new String[0]));
        if (datalake.isSshMirrored()) {
            SshMirroredDatalake mirror = datalake.asSshMirrored();
            builder.add("parameter", (Object)this.parameter(mirror.url(), new String[0])).add("parameter", (Object)this.parameter(mirror.user(), new String[0])).add("parameter", (Object)this.parameter(mirror.password(), new String[0])).add("parameter", (Object)this.parameter(mirror.originDatalakePath(), new String[0])).add("parameter", (Object)this.parameter(mirror.startingTimetag(), new String[0]));
        } else if (datalake.isNfsMirrored()) {
            builder.add("parameter", (Object)this.parameter(datalake.asNfsMirrored().originDatalakePath(), new String[0])).add("parameter", (Object)this.parameter(datalake.asNfsMirrored().startingTimetag(), new String[0]));
        }
        root.add("datalake", (Object)builder);
    }

    private void messageHub(FrameBuilder root, String boxName) {
        Frame[] mounterFrames;
        MessageHub hub = this.graph.messageHub();
        if (hub == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"messagehub"});
        if (hub.isJmsBus()) {
            JmsBusMessageHub jmsHub = hub.asJmsBus();
            builder.add("jms").add("parameter", (Object)this.parameter(jmsHub.url(), new String[0])).add("parameter", (Object)this.parameter(jmsHub.user(), new String[0])).add("parameter", (Object)this.parameter(jmsHub.password(), new String[0])).add("parameter", (Object)this.parameter(jmsHub.clientId(), new String[0]));
        }
        builder.add("package", (Object)this.packageName());
        Frame[] feederFrames = (Frame[])this.graph.feederList().stream().filter(f -> !f.sensorList().isEmpty()).map(this::frameOf).toArray(Frame[]::new);
        if (feederFrames.length != 0) {
            builder.add("feeder", (Object)feederFrames);
        }
        if ((mounterFrames = (Frame[])this.graph.mounterList().stream().filter(Mounter::isRealtime).map(m -> this.frameOf((Mounter)((Object)m), boxName)).toArray(Frame[]::new)).length != 0) {
            builder.add("mounter", (Object)mounterFrames);
        }
        root.add("messagehub", (Object)builder.toFrame());
    }

    private void workflow(FrameBuilder root) {
        if (this.graph.workflow() == null || this.graph.workflow().processList().isEmpty()) {
            return;
        }
        root.add("workflow", (Object)this.buildBaseFrame().add("workflow"));
        this.konosParameters.add("workspace");
    }

    private Frame frameOf(Mounter m, String boxName) {
        RealtimeMounter mounter = m.asRealtime();
        FrameBuilder[] subscriptions = (FrameBuilder[])mounter.sourceList().stream().filter(s -> Objects.nonNull(s.channel())).map(RealtimeMounter.Source::channel).map(t -> new FrameBuilder(new String[]{"subscription"}).add("tankName", t).add("box", (Object)boxName).add("package", (Object)this.packageName()).add("name", (Object)mounter.name$()).add("subscriberId", (Object)mounter.subscriberId())).toArray(FrameBuilder[]::new);
        FrameBuilder mounterFrame = new FrameBuilder(new String[]{"mounter", "realtime"});
        return mounterFrame.add("name", (Object)mounter.name$()).add("subscription", (Object)subscriptions).toFrame();
    }

    @NotNull
    private FrameBuilder parameter(String parameter, String ... types) {
        FrameBuilder frameBuilder = new FrameBuilder(types).add("parameter").add(this.isCustom(parameter) ? "custom" : "standard").add("value", (Object)parameter);
        if (frameBuilder == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    @NotNull
    private Frame parameter(SlackBotService service) {
        Frame frame = new FrameBuilder(new String[]{this.isCustom(service.token()) ? "custom" : "standard"}).add("value", (Object)service.token()).toFrame();
        if (frame == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(1);
        }
        return frame;
    }

    private Frame frameOf(Feeder feeder) {
        return new FrameBuilder(new String[]{"feeder"}).add("package", (Object)this.packageName()).add("name", (Object)feeder.name$()).add("box", (Object)this.settings.boxName()).toFrame();
    }

    private void services(FrameBuilder builder, String name) {
        if (!this.graph.messagingServiceList().isEmpty()) {
            builder.add("jms", (Object)"");
        }
        this.rest(builder, name);
        this.jms(builder, name);
        this.jmx(builder, name);
        this.slackServices(builder, name);
        if (!this.graph.rESTServiceList().isEmpty() || !this.graph.uIServiceList().isEmpty()) {
            builder.add("spark", (Object)"stop");
        }
        this.ui(builder, name);
    }

    private void rest(FrameBuilder frame, String name) {
        for (RESTService service : this.graph.rESTServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "rest"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service.port(), new String[0])).toFrame());
        }
    }

    private boolean hasAuthenticatedApis() {
        return this.graph.rESTServiceList().stream().anyMatch(restService -> restService.authenticatedWithToken() != null);
    }

    private void jms(FrameBuilder frame, String name) {
        for (MessagingService service : this.graph.messagingServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jms"}).add("name", (Object)service.name$()).add("configuration", (Object)name));
        }
    }

    private void jmx(FrameBuilder frame, String name) {
        for (JMXService service : this.graph.jMXServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jmx"}).add("name", (Object)service.name$()).add("configuration", (Object)name).toFrame());
        }
    }

    private void slackServices(FrameBuilder frame, String name) {
        for (SlackBotService service : this.graph.slackBotServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "slack"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service)).toFrame());
        }
    }

    private void ui(FrameBuilder builder, String name) {
        if (!this.graph.uIServiceList().isEmpty()) {
            FrameBuilder uiFrame = new FrameBuilder();
            if (this.settings.parent() != null) {
                uiFrame.add("parent", (Object)this.settings.parent());
            }
            builder.add("hasUi", (Object)uiFrame);
            builder.add("uiAuthentication", (Object)uiFrame);
            builder.add("uiEdition", (Object)uiFrame);
            builder.add("service", this.graph.uIServiceList().stream().map(s -> this.ui((UIService)((Object)s), name)).toArray(Frame[]::new));
        }
    }

    private Frame ui(UIService service, String name) {
        FrameBuilder builder = new FrameBuilder(new String[]{"service", "ui"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service.port(), new String[0]).toFrame()).add("package", (Object)this.packageName());
        if (service.authentication() != null) {
            builder.add("authentication", (Object)this.parameter(service.authentication().by(), new String[0]).toFrame());
        }
        if (service.edition() != null) {
            builder.add("edition", (Object)new FrameBuilder(new String[]{this.isCustom(service.edition().by()) ? "custom" : "standard"}).add("value", (Object)service.edition().by()).toFrame());
        }
        service.useList().forEach(use -> builder.add("use", (Object)(use.className() + "Service")));
        return builder.toFrame();
    }

    private boolean isCustom(String value) {
        boolean custom;
        boolean bl = custom = value != null && value.startsWith("{");
        if (custom) {
            this.konosParameters.add(value.substring(1, value.length() - 1));
        }
        return custom;
    }

    private void parent(FrameBuilder builder) {
        if (this.parent() != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            builder.add("parent", (Object)this.parent()).add("hasParent", (Object)"");
        } else {
            builder.add("hasntParent", (Object)"");
        }
    }

    private Template template() {
        return Formatters.customize(new AbstractBoxTemplate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/AbstractBoxRenderer", "parameter"));
    }
}

