/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Service
extends Layer
implements Terminal {
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected List<Exception> exceptionList = new ArrayList<Exception>();

    public Service(Node node) {
        super(node);
    }

    public List<Schema> schemaList() {
        return Collections.unmodifiableList(this.schemaList);
    }

    public Schema schema(int index) {
        return this.schemaList.get(index);
    }

    public List<Schema> schemaList(Predicate<Schema> predicate) {
        return this.schemaList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Exception> exceptionList() {
        return Collections.unmodifiableList(this.exceptionList);
    }

    public Exception exception(int index) {
        return this.exceptionList.get(index);
    }

    public List<Exception> exceptionList(Predicate<Exception> predicate) {
        return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public JMSService asJMS() {
        return (JMSService)this.a$(JMSService.class);
    }

    public JMSService asJMS(String url, String user, String password, String clientId, JMSService.SubscriptionModel subscriptionModel) {
        JMSService newElement = (JMSService)this.core$().addFacet(JMSService.class);
        newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
        newElement.core$().set((Layer)newElement, "user", Collections.singletonList(user));
        newElement.core$().set((Layer)newElement, "password", Collections.singletonList(password));
        newElement.core$().set((Layer)newElement, "clientId", Collections.singletonList(clientId));
        newElement.core$().set((Layer)newElement, "subscriptionModel", Collections.singletonList(subscriptionModel));
        return newElement;
    }

    public boolean isJMS() {
        return this.core$().is(JMSService.class);
    }

    public void removeJMS() {
        this.core$().removeFacet(JMSService.class);
    }

    public RESTService asREST() {
        return (RESTService)this.a$(RESTService.class);
    }

    public RESTService asREST(String host, String port) {
        RESTService newElement = (RESTService)this.core$().addFacet(RESTService.class);
        newElement.core$().set((Layer)newElement, "host", Collections.singletonList(host));
        newElement.core$().set((Layer)newElement, "port", Collections.singletonList(port));
        return newElement;
    }

    public boolean isREST() {
        return this.core$().is(RESTService.class);
    }

    public void removeREST() {
        this.core$().removeFacet(RESTService.class);
    }

    public UIService asUI() {
        return (UIService)this.a$(UIService.class);
    }

    public UIService asUI(String port, String title, String favicon) {
        UIService newElement = (UIService)this.core$().addFacet(UIService.class);
        newElement.core$().set((Layer)newElement, "port", Collections.singletonList(port));
        newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
        newElement.core$().set((Layer)newElement, "favicon", Collections.singletonList(favicon));
        return newElement;
    }

    public boolean isUI() {
        return this.core$().is(UIService.class);
    }

    public void removeUI() {
        this.core$().removeFacet(UIService.class);
    }

    public JMXService asJMX() {
        Layer as = this.a$(JMXService.class);
        return as != null ? (JMXService)as : (JMXService)this.core$().addFacet(JMXService.class);
    }

    public boolean isJMX() {
        return this.core$().is(JMXService.class);
    }

    public SlackBotService asSlackBot() {
        return (SlackBotService)this.a$(SlackBotService.class);
    }

    public SlackBotService asSlackBot(String token) {
        SlackBotService newElement = (SlackBotService)this.core$().addFacet(SlackBotService.class);
        newElement.core$().set((Layer)newElement, "token", Collections.singletonList(token));
        return newElement;
    }

    public boolean isSlackBot() {
        return this.core$().is(SlackBotService.class);
    }

    public void removeSlackBot() {
        this.core$().removeFacet(SlackBotService.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Schema>(this.schemaList).forEach(c -> components.add(c.core$()));
        new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Schema")) {
            this.schemaList.add((Schema)node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.add((Exception)node.as(Exception.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Schema")) {
            this.schemaList.remove(node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.remove(node.as(Exception.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(Service.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(Service.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Schema schema() {
            Schema newElement = (Schema)Service.this.core$().graph().concept(Schema.class).createNode(this.name, Service.this.core$()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)Service.this.core$().graph().concept(Exception.class).createNode(this.name, Service.this.core$()).as(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

