/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Adapter;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.datahublocation.DataHubLocationDataHub;
import io.intino.konos.model.graph.event.datahub.EventTank;
import io.intino.konos.model.graph.local.LocalDataHub;
import io.intino.konos.model.graph.mirrored.MirroredDataHub;
import io.intino.konos.model.graph.remote.RemoteDataHub;
import io.intino.konos.model.graph.set.datahub.SetTank;
import io.intino.konos.model.graph.singleton.datahub.SingletonTank;
import io.intino.konos.model.graph.standalone.StandAloneDataHub;
import io.intino.konos.model.graph.tanktype.datahub.TankTypeTank;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DataHub
extends Layer
implements Terminal {
    protected String workingDirectory;
    protected List<Split> splitList = new ArrayList<Split>();
    protected List<Tank> tankList = new ArrayList<Tank>();
    protected List<Adapter> adapterList = new ArrayList<Adapter>();
    protected List<Mounter> mounterList = new ArrayList<Mounter>();
    protected List<Feeder> feederList = new ArrayList<Feeder>();

    public DataHub(Node node) {
        super(node);
    }

    public String workingDirectory() {
        return this.workingDirectory;
    }

    public DataHub workingDirectory(String value) {
        this.workingDirectory = value;
        return this;
    }

    public List<Split> splitList() {
        return Collections.unmodifiableList(this.splitList);
    }

    public Split split(int index) {
        return this.splitList.get(index);
    }

    public List<Split> splitList(Predicate<Split> predicate) {
        return this.splitList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Tank> tankList() {
        return Collections.unmodifiableList(this.tankList);
    }

    public Tank tank(int index) {
        return this.tankList.get(index);
    }

    public List<Tank> tankList(Predicate<Tank> predicate) {
        return this.tankList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Adapter> adapterList() {
        return Collections.unmodifiableList(this.adapterList);
    }

    public Adapter adapter(int index) {
        return this.adapterList.get(index);
    }

    public List<Adapter> adapterList(Predicate<Adapter> predicate) {
        return this.adapterList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Mounter> mounterList() {
        return Collections.unmodifiableList(this.mounterList);
    }

    public Mounter mounter(int index) {
        return this.mounterList.get(index);
    }

    public List<Mounter> mounterList(Predicate<Mounter> predicate) {
        return this.mounterList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Feeder> feederList() {
        return Collections.unmodifiableList(this.feederList);
    }

    public Feeder feeder(int index) {
        return this.feederList.get(index);
    }

    public List<Feeder> feederList(Predicate<Feeder> predicate) {
        return this.feederList().stream().filter(predicate).collect(Collectors.toList());
    }

    public MirroredDataHub asMirrored() {
        return (MirroredDataHub)this.a$(MirroredDataHub.class);
    }

    public MirroredDataHub asMirrored(String originSshUrl, String originDatalakePath, String user, String destinationPath, String startingTimetag) {
        MirroredDataHub newElement = (MirroredDataHub)this.core$().addFacet(MirroredDataHub.class);
        newElement.core$().set((Layer)newElement, "originSshUrl", Collections.singletonList(originSshUrl));
        newElement.core$().set((Layer)newElement, "originDatalakePath", Collections.singletonList(originDatalakePath));
        newElement.core$().set((Layer)newElement, "user", Collections.singletonList(user));
        newElement.core$().set((Layer)newElement, "destinationPath", Collections.singletonList(destinationPath));
        newElement.core$().set((Layer)newElement, "startingTimetag", Collections.singletonList(startingTimetag));
        return newElement;
    }

    public boolean isMirrored() {
        return this.core$().is(MirroredDataHub.class);
    }

    public void removeMirrored() {
        this.core$().removeFacet(MirroredDataHub.class);
    }

    public RemoteDataHub asRemote() {
        Layer as = this.a$(RemoteDataHub.class);
        return as != null ? (RemoteDataHub)as : (RemoteDataHub)this.core$().addFacet(RemoteDataHub.class);
    }

    public boolean isRemote() {
        return this.core$().is(RemoteDataHub.class);
    }

    public StandAloneDataHub asStandAlone() {
        return (StandAloneDataHub)this.a$(StandAloneDataHub.class);
    }

    public StandAloneDataHub asStandAlone(String datalakePath, StandAloneDataHub.Scale scale) {
        StandAloneDataHub newElement = (StandAloneDataHub)this.core$().addFacet(StandAloneDataHub.class);
        newElement.core$().set((Layer)newElement, "datalakePath", Collections.singletonList(datalakePath));
        newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
        return newElement;
    }

    public boolean isStandAlone() {
        return this.core$().is(StandAloneDataHub.class);
    }

    public void removeStandAlone() {
        this.core$().removeFacet(StandAloneDataHub.class);
    }

    public LocalDataHub asLocal() {
        return (LocalDataHub)this.a$(LocalDataHub.class);
    }

    public LocalDataHub asLocal(String datalakePath) {
        LocalDataHub newElement = (LocalDataHub)this.core$().addFacet(LocalDataHub.class);
        newElement.core$().set((Layer)newElement, "datalakePath", Collections.singletonList(datalakePath));
        return newElement;
    }

    public boolean isLocal() {
        return this.core$().is(LocalDataHub.class);
    }

    public void removeLocal() {
        this.core$().removeFacet(LocalDataHub.class);
    }

    public DataHubLocationDataHub asDataHubLocation() {
        Layer as = this.a$(DataHubLocationDataHub.class);
        return as != null ? (DataHubLocationDataHub)as : null;
    }

    public boolean isDataHubLocation() {
        return this.core$().is(DataHubLocationDataHub.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Split>(this.splitList).forEach(c -> components.add(c.core$()));
        new ArrayList<Tank>(this.tankList).forEach(c -> components.add(c.core$()));
        new ArrayList<Adapter>(this.adapterList).forEach(c -> components.add(c.core$()));
        new ArrayList<Mounter>(this.mounterList).forEach(c -> components.add(c.core$()));
        new ArrayList<Feeder>(this.feederList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("workingDirectory", new ArrayList<String>(Collections.singletonList(this.workingDirectory)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("DataHub$Split")) {
            this.splitList.add((Split)node.as(Split.class));
        }
        if (node.is("DataHub$Tank")) {
            this.tankList.add((Tank)node.as(Tank.class));
        }
        if (node.is("Adapter")) {
            this.adapterList.add((Adapter)node.as(Adapter.class));
        }
        if (node.is("Mounter")) {
            this.mounterList.add((Mounter)node.as(Mounter.class));
        }
        if (node.is("Feeder")) {
            this.feederList.add((Feeder)node.as(Feeder.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("DataHub$Split")) {
            this.splitList.remove(node.as(Split.class));
        }
        if (node.is("DataHub$Tank")) {
            this.tankList.remove(node.as(Tank.class));
        }
        if (node.is("Adapter")) {
            this.adapterList.remove(node.as(Adapter.class));
        }
        if (node.is("Mounter")) {
            this.mounterList.remove(node.as(Mounter.class));
        }
        if (node.is("Feeder")) {
            this.feederList.remove(node.as(Feeder.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("workingDirectory")) {
            this.workingDirectory = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("workingDirectory")) {
            this.workingDirectory = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Tank
    extends Layer
    implements Terminal {
        protected String fullName;

        public Tank(Node node) {
            super(node);
        }

        public String fullName() {
            return this.fullName;
        }

        public Tank fullName(String value) {
            this.fullName = value;
            return this;
        }

        public SetTank asSet() {
            Layer as = this.a$(SetTank.class);
            return as != null ? (SetTank)as : (SetTank)this.core$().addFacet(SetTank.class);
        }

        public boolean isSet() {
            return this.core$().is(SetTank.class);
        }

        public TankTypeTank asTankType() {
            Layer as = this.a$(TankTypeTank.class);
            return as != null ? (TankTypeTank)as : null;
        }

        public boolean isTankType() {
            return this.core$().is(TankTypeTank.class);
        }

        public SingletonTank asSingleton() {
            Layer as = this.a$(SingletonTank.class);
            return as != null ? (SingletonTank)as : (SingletonTank)this.core$().addFacet(SingletonTank.class);
        }

        public boolean isSingleton() {
            return this.core$().is(SingletonTank.class);
        }

        public EventTank asEvent() {
            return (EventTank)this.a$(EventTank.class);
        }

        public EventTank asEvent(Schema schema) {
            EventTank newElement = (EventTank)this.core$().addFacet(EventTank.class);
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        public boolean isEvent() {
            return this.core$().is(EventTank.class);
        }

        public void removeEvent() {
            this.core$().removeFacet(EventTank.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("fullName", new ArrayList<String>(Collections.singletonList(this.fullName)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("fullName")) {
                this.fullName = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("fullName")) {
                this.fullName = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Split
    extends Layer
    implements Terminal {
        protected List<String> splits = new ArrayList<String>();

        public Split(Node node) {
            super(node);
        }

        public List<String> splits() {
            return this.splits;
        }

        public String splits(int index) {
            return this.splits.get(index);
        }

        public List<String> splits(Predicate<String> predicate) {
            return this.splits().stream().filter(predicate).collect(Collectors.toList());
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("splits", this.splits);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("splits")) {
                this.splits = StringLoader.load(values, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("splits")) {
                this.splits = new ArrayList(values);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void split(Predicate<Split> filter) {
            new ArrayList<Split>(DataHub.this.splitList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void tank(Predicate<Tank> filter) {
            new ArrayList<Tank>(DataHub.this.tankList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void adapter(Predicate<Adapter> filter) {
            new ArrayList<Adapter>(DataHub.this.adapterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void mounter(Predicate<Mounter> filter) {
            new ArrayList<Mounter>(DataHub.this.mounterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void feeder(Predicate<Feeder> filter) {
            new ArrayList<Feeder>(DataHub.this.feederList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Split split(List<String> splits) {
            Split newElement = (Split)DataHub.this.core$().graph().concept(Split.class).createNode(this.name, DataHub.this.core$()).as(Split.class);
            newElement.core$().set((Layer)newElement, "splits", splits);
            return newElement;
        }

        public Tank tank(String fullName) {
            Tank newElement = (Tank)DataHub.this.core$().graph().concept(Tank.class).createNode(this.name, DataHub.this.core$()).as(Tank.class);
            newElement.core$().set((Layer)newElement, "fullName", Collections.singletonList(fullName));
            return newElement;
        }

        public Adapter adapter() {
            Adapter newElement = (Adapter)DataHub.this.core$().graph().concept(Adapter.class).createNode(this.name, DataHub.this.core$()).as(Adapter.class);
            return newElement;
        }

        public Mounter mounter() {
            Mounter newElement = (Mounter)DataHub.this.core$().graph().concept(Mounter.class).createNode(this.name, DataHub.this.core$()).as(Mounter.class);
            return newElement;
        }

        public Feeder feeder(List<Tank> tanks) {
            Feeder newElement = (Feeder)DataHub.this.core$().graph().concept(Feeder.class).createNode(this.name, DataHub.this.core$()).as(Feeder.class);
            newElement.core$().set((Layer)newElement, "tanks", tanks);
            return newElement;
        }
    }
}

