/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.resource;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.AccessibleDisplayActionRenderer;
import io.intino.konos.builder.codegeneration.action.UIActionRenderer;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.resource.ResourceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.accessible.AccessibleDisplay;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.Map;

public class ResourceRenderer
extends UIRenderer {
    private final Project project;
    private final File src;
    private final File gen;
    private final List<AbstractUIService.Resource> resourceList;
    private final Map<String, String> classes;
    private final List<AccessibleDisplay> accessibleDisplays;

    public ResourceRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        super(boxName, packageName);
        this.project = project;
        this.src = src;
        this.gen = gen;
        this.resourceList = graph.core$().find(AbstractUIService.Resource.class);
        this.accessibleDisplays = graph.accessibleDisplayList();
        this.classes = classes;
    }

    public void execute() {
        this.resourceList.forEach(this::processResource);
        this.accessibleDisplays.forEach(this::processDisplay);
    }

    private void processDisplay(AccessibleDisplay display) {
        Commons.writeFrame(new File(this.gen, "resources"), this.name(display.name$(), "ProxyResource"), this.template().render((Object)this.frameBuilder().add("name", (Object)display.name$()).add("resource").add(((Object)((Object)display)).getClass().getSimpleName()).add("parameter", (Object)this.parameters(display)).toFrame()));
        this.createCorrespondingAction(display);
    }

    private void processResource(AbstractUIService.Resource resource) {
        UIService uiService = (UIService)resource.core$().ownerAs(UIService.class);
        FrameBuilder builder = this.frameBuilder().add("resource").add("name", (Object)resource.name$()).add("parameter", (Object)this.parameters(resource));
        if (resource.isEditorPage()) {
            builder.add("editor", (Object)"Editor");
        }
        if (uiService.googleApiKey() != null) {
            builder.add("googleApiKey", (Object)Formatters.customize("googleApiKey", uiService.googleApiKey()));
        }
        if (resource.isConfidential()) {
            builder.add("confidential", (Object)"");
        }
        Commons.writeFrame(new File(this.gen, "resources"), this.name(resource.name$(), "Resource"), this.template().render((Object)builder.toFrame()));
        this.createCorrespondingAction(resource);
    }

    private String name(String s, String proxyResource) {
        return StringHelper.snakeCaseToCamelCase((String)(s + proxyResource));
    }

    private void createCorrespondingAction(AbstractUIService.Resource resource) {
        new UIActionRenderer(this.project, resource, this.src, this.gen, this.packageName, this.box, this.classes).execute();
    }

    private void createCorrespondingAction(AccessibleDisplay display) {
        new AccessibleDisplayActionRenderer(this.project, display, this.src, this.packageName, this.box, this.classes).execute();
    }

    private Template template() {
        return this.customized(new ResourceTemplate());
    }

    private Template customized(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
        return template;
    }

    private Frame[] parameters(AbstractUIService.Resource resource) {
        List<String> parameters = Commons.extractUrlPathParameters(resource.path());
        return (Frame[])parameters.stream().map(parameter -> new FrameBuilder(new String[]{"parameter"}).add("name", parameter).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] parameters(AccessibleDisplay display) {
        return (Frame[])display.parameters().stream().map(parameter -> new FrameBuilder(new String[]{"parameter"}).add("name", parameter).toFrame()).toArray(Frame[]::new);
    }
}

