/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.panel;

import com.intellij.openapi.project.Project;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.AbstractPanelTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelUpdater;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.OperationRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.view.ViewRenderer;
import io.intino.konos.model.graph.AbstractToolbar;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.Toolbar;
import io.intino.konos.model.graph.View;
import java.io.File;

public class PanelRenderer
extends DisplayRenderer {
    private final Project project;

    public PanelRenderer(Project project, Panel panel, String packageName, String boxName) {
        super(panel, boxName, packageName);
        this.project = project;
    }

    @Override
    public FrameBuilder frameBuilder() {
        Panel panel = (Panel)this.display().a$(Panel.class);
        FrameBuilder builder = super.frameBuilder();
        builder.add(panel.isDesktop() ? "desktop" : "panel");
        if (panel.label() != null) {
            builder.add("label", (Object)panel.label());
        }
        if (panel.toolbar() != null) {
            builder.add("toolbar", (Object)this.frameOf(panel.toolbar()));
        }
        this.views(panel.views(), builder);
        return builder;
    }

    private FrameBuilder frameOf(Toolbar toolbar) {
        return new FrameBuilder(new String[]{"toolbar"}).add("box", (Object)this.box).add("canSearch", (Object)toolbar.canSearch()).add("operation", toolbar.operations().stream().map(o -> new OperationRenderer((AbstractToolbar.Operation)((Object)o), this.display(), this.box, this.packageName).frameBuilder().toFrame()).toArray(Frame[]::new));
    }

    private void views(Panel.Views views, FrameBuilder frame) {
        views.viewList().forEach(view -> frame.add("view", (Object)new FrameBuilder().add("value", (Object)new ViewRenderer((View)((Object)view), this.display(), this.box, this.packageName).frameBuilder())));
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(new PanelTemplate());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(new AbstractPanelTemplate());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return new PanelUpdater(sourceFile, (Panel)this.display().a$(Panel.class), this.project, this.packageName, this.box);
    }
}

