/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayNotifierTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayUpdater;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.CatalogRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.desktop.DesktopRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.editor.EditorRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.mold.MoldRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.Editor;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.konos.model.graph.accessible.AccessibleDisplay;
import io.intino.konos.model.graph.desktop.DesktopPanel;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DisplayRenderer
extends UIRenderer {
    private final Project project;
    private final File gen;
    private final File src;
    private final List<Display> displays;
    private final Map<String, String> classes;
    private final String parent;

    public DisplayRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String parent, String boxName, Map<String, String> classes) {
        super(boxName, packageName);
        this.project = project;
        this.gen = gen;
        this.src = src;
        this.parent = parent;
        this.displays = graph.displayList();
        this.classes = classes;
    }

    static FrameBuilder frameOf(Display.Request request, String packageName) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"});
        if (request.responseType().equals((Object)Display.Request.ResponseType.Asset)) {
            builder.add("asset");
        }
        builder.add("name", (Object)request.name$());
        if (request.isType()) {
            FrameBuilder parameterFrame = new FrameBuilder(new String[]{"parameter", request.asType().type(), ((Object)((Object)request.asType())).getClass().getSimpleName().replace("Data", "")}).add("value", (Object)DisplayRenderer.parameter(request, packageName));
            if (request.isList()) {
                parameterFrame.add("list");
            }
            builder.add("parameter", (Object)parameterFrame.toFrame());
        }
        return builder;
    }

    private static String parameter(Display.Request request, String packageName) {
        return request.isObject() ? packageName.toLowerCase() + ".schemas." + request.asType().type() : request.asType().type();
    }

    public void execute() {
        this.displays.forEach(this::processDisplay);
    }

    private void processDisplay(Display display) {
        if (display == null) {
            return;
        }
        FrameBuilder builder = this.createFrameBuilder(display);
        this.writeNotifier(display, builder.toFrame());
        this.writeRequester(display, builder.toFrame());
        if (((Object)((Object)display)).getClass().getSimpleName().equals(Display.class.getSimpleName())) {
            this.writeDisplay(display, builder.toFrame());
        } else {
            this.processPrototype(display);
        }
        if (display.isAccessible()) {
            this.writeDisplaysFor(display.asAccessible(), builder);
        }
    }

    private void processPrototype(Display display) {
        this.classes.put(((Object)((Object)display)).getClass().getSimpleName() + "#" + display.name$(), "displays." + StringHelper.snakeCaseToCamelCase((String)display.name$()));
        if (display.i$(Editor.class)) {
            new EditorRenderer(this.project, (Editor)display.a$(Editor.class), this.packageName, this.box).write(this.src, this.gen);
        } else if (display.i$(Catalog.class)) {
            new CatalogRenderer(this.project, (Catalog)display.a$(Catalog.class), this.packageName, this.box).write(this.src, this.gen);
        } else if (display.i$(Panel.class)) {
            Panel panel = (Panel)display.a$(Panel.class);
            if (panel.isDesktop()) {
                DesktopPanel desktop = ((Panel)display.a$(Panel.class)).asDesktop();
                new DesktopRenderer(this.project, desktop, this.packageName, this.box).write(this.src, this.gen);
            } else {
                new PanelRenderer(this.project, (Panel)display.a$(Panel.class), this.packageName, this.box).write(this.src, this.gen);
            }
        } else if (display.i$(Mold.class)) {
            new MoldRenderer(this.project, (Mold)display.a$(Mold.class), this.packageName, this.box).write(this.src, this.gen);
        }
    }

    private void writeDisplay(Display display, Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)display.name$());
        this.classes.put("Display#" + display.name$(), "displays." + newDisplay);
        if (!Commons.javaFile(new File(this.src, "displays"), newDisplay).exists()) {
            Commons.writeFrame(new File(this.src, "displays"), newDisplay, this.displayTemplate().render((Object)frame));
        } else {
            new DisplayUpdater(this.project, display, Commons.javaFile(new File(this.src, "displays"), newDisplay), this.packageName).update();
        }
    }

    private void writeRequester(Display display, Frame frame) {
        Commons.writeFrame(new File(this.gen, REQUESTERS), StringHelper.snakeCaseToCamelCase((String)(display.name$() + (frame.is("accessible") ? "Proxy" : "") + "Requester")), this.displayRequesterTemplate().render((Object)frame));
    }

    private void writeNotifier(Display display, Frame frame) {
        Commons.writeFrame(new File(this.gen, NOTIFIERS), StringHelper.snakeCaseToCamelCase((String)(display.name$() + (frame.is("accessible") ? "Proxy" : "") + "Notifier")), this.displayNotifierTemplate().render((Object)frame));
    }

    private void writeDisplaysFor(AccessibleDisplay display, FrameBuilder builder) {
        builder.add("accessible");
        String name = StringHelper.snakeCaseToCamelCase((String)display.name$());
        Commons.writeFrame(new File(this.src, "displays"), name + "Proxy", this.displayTemplate().render((Object)builder.add("accessible")));
        this.writeNotifier((Display)display.a$(Display.class), builder.toFrame());
        this.writeRequester((Display)display.a$(Display.class), builder.toFrame());
    }

    @NotNull
    private FrameBuilder createFrameBuilder(Display display) {
        FrameBuilder builder = new FrameBuilder(new String[]{"display"});
        builder.add("package", (Object)this.packageName);
        builder.add("name", (Object)display.name$());
        builder.add("type", (Object)this.typeOf(display));
        builder.add("innerDisplay", display.displays().stream().map(Layer::name$).toArray(String[]::new));
        if (display.parentDisplay() != null) {
            this.addParent(display, builder);
        }
        if (!display.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
        }
        builder.add("notification", (Object)this.framesOfNotifications(display.notificationList()));
        builder.add("request", (Object)this.framesOfRequests(display.requestList()));
        builder.add("box", (Object)this.box);
        if (display.isAccessible()) {
            builder.add("parameter", display.asAccessible().parameters().stream().map(p -> new FrameBuilder(new String[]{"parameter", "accessible"}).add("value", p).toFrame()).toArray(Frame[]::new));
        }
        FrameBuilder frameBuilder = builder;
        if (frameBuilder == null) {
            DisplayRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private String typeOf(Display display) {
        String type = ((Object)((Object)display)).getClass().getSimpleName().toLowerCase();
        if (display.i$(DesktopPanel.class)) {
            return "desktop";
        }
        if (type.equalsIgnoreCase("temporalCatalog")) {
            return "temporal" + ((TemporalCatalog)display.a$(TemporalCatalog.class)).type().name() + "Catalog";
        }
        return type;
    }

    private void addParent(Display display, FrameBuilder builder) {
        builder.add("parent", (Object)new FrameBuilder().add("value", (Object)display.parentDisplay()).add("dsl", (Object)this.parent).add("package", (Object)this.parent.substring(0, this.parent.lastIndexOf("."))));
    }

    private Frame[] framesOfNotifications(List<Display.Notification> notifications) {
        return (Frame[])notifications.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(Display.Notification notification) {
        FrameBuilder builder = new FrameBuilder(new String[]{"notification"});
        builder.add("name", (Object)notification.name$());
        builder.add("target", (Object)notification.to().name());
        if (notification.isType()) {
            FrameBuilder parameterFrame = new FrameBuilder(new String[]{"parameter", notification.asType().type(), ((Object)((Object)notification.asType())).getClass().getSimpleName().replace("Data", "")}).add("value", (Object)notification.asType().type());
            if (notification.isList()) {
                parameterFrame.add("list");
            }
            builder.add("parameter", (Object)parameterFrame);
        }
        return builder.toFrame();
    }

    private Frame[] framesOfRequests(List<Display.Request> requests) {
        return (Frame[])requests.stream().map(r -> DisplayRenderer.frameOf(r, this.packageName).toFrame()).toArray(Frame[]::new);
    }

    private Template displayNotifierTemplate() {
        DisplayNotifierTemplate template = new DisplayNotifierTemplate();
        this.addFormats(template);
        return template;
    }

    private Template displayTemplate() {
        DisplayTemplate template = new DisplayTemplate();
        this.addFormats(template);
        return template;
    }

    private Template displayRequesterTemplate() {
        DisplayRequesterTemplate template = new DisplayRequesterTemplate();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/ui/display/DisplayRenderer", "createFrameBuilder"));
    }
}

