/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.dialog;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.AbstractDialogTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.multiple.dialog.tab.MultipleInput;
import java.io.File;
import java.util.List;

public class AbstractDialogRenderer
extends UIRenderer {
    private final File gen;
    private final List<Dialog> dialogs;

    AbstractDialogRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        super(boxName, packageName);
        this.gen = gen;
        this.dialogs = graph.dialogList();
    }

    public void execute() {
        this.dialogs.forEach(this::processDialog);
    }

    private void processDialog(Dialog dialog) {
        FrameBuilder frame = new FrameBuilder(new String[]{"dialogDisplay"});
        frame.add("package", (Object)this.packageName);
        frame.add("name", (Object)dialog.name$());
        frame.add("box", (Object)this.box);
        FrameBuilder dialogFrame = new FrameBuilder(new String[]{"dialog"});
        if (!dialog.label().isEmpty()) {
            dialogFrame.add("label", (Object)dialog.label());
        }
        if (!dialog.description().isEmpty()) {
            dialogFrame.add("description", (Object)dialog.description());
        }
        frame.add("dialog", (Object)dialogFrame);
        this.createToolbar(dialogFrame, dialog.name$(), dialog.toolbar());
        for (Dialog.Tab tab : dialog.tabList()) {
            dialogFrame.add("tab", (Object)this.frameOf(tab));
        }
        Commons.writeFrame(new File(this.gen, "dialogs"), "Abstract" + StringHelper.snakeCaseToCamelCase((String)dialog.name$()), this.template().render((Object)frame));
    }

    private void createToolbar(FrameBuilder builder, String dialog, Dialog.Toolbar toolbar) {
        if (toolbar == null) {
            return;
        }
        for (Dialog.Toolbar.Operation operation : toolbar.operationList()) {
            builder.add("operation", (Object)this.frameOf(dialog, operation.name$(), operation.label(), operation.closeAfterExecution()));
        }
    }

    private Frame frameOf(String dialog, String operation, String operationLabel, boolean closeAfterExecution) {
        FrameBuilder builder = new FrameBuilder(new String[]{"operation"}).add("dialog", (Object)dialog).add("execution", (Object)operation);
        if (!operation.isEmpty()) {
            builder.add("name", (Object)operation).add("label", (Object)operationLabel);
        }
        builder.add("closeAfterExecution", (Object)closeAfterExecution);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab tab) {
        FrameBuilder tabBuilder = new FrameBuilder(new String[]{"tab"});
        if (!tab.name$().isEmpty()) {
            tabBuilder.add("name", (Object)tab.name$());
        }
        if (!tab.label().isEmpty()) {
            tabBuilder.add("label", (Object)tab.label());
        }
        for (Dialog.Tab.Input input : tab.inputList()) {
            this.processInput(tabBuilder, input);
        }
        return tabBuilder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Text text) {
        FrameBuilder builder = new FrameBuilder(new String[]{"text"});
        if (text.edition() != null) {
            builder.add("edition", (Object)text.edition());
        }
        if (text.validation() != null) {
            builder.add("validation", (Object)this.frameOf(text.validation()));
        }
        this.addCommon(builder, text);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Text.Validation validation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"text", "validation"});
        if (!validation.allowedValues().isEmpty()) {
            builder.add("allowedValues", (Object)validation.allowedValues().toArray(new String[0]));
        }
        if (!validation.disallowedValues().isEmpty()) {
            builder.add("disallowedValues", (Object)validation.disallowedValues().toArray(new String[0]));
        }
        builder.add("disallowEmptySpaces", (Object)validation.disallowEmptySpaces());
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Section section) {
        FrameBuilder builder = new FrameBuilder(new String[]{"section"});
        List<Dialog.Tab.Input> inputs = section.inputList();
        for (Dialog.Tab.Input input : inputs) {
            this.processInput(builder, input);
        }
        this.addCommon(builder, section);
        return builder.toFrame();
    }

    private void processInput(FrameBuilder builder, Dialog.Tab.Input input) {
        if (input.i$(Dialog.Tab.Text.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.Text)input));
        } else if (input.i$(Dialog.Tab.Section.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.Section)input));
        } else if (input.i$(Dialog.Tab.Memo.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.Memo)input));
        } else if (input.i$(Dialog.Tab.RadioBox.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.RadioBox)input));
        } else if (input.i$(Dialog.Tab.CheckBox.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.CheckBox)input));
        } else if (input.i$(Dialog.Tab.ComboBox.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.ComboBox)input));
        } else if (input.i$(Dialog.Tab.Password.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.Password)input));
        } else if (input.i$(Dialog.Tab.File.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.File)input));
        } else if (input.i$(Dialog.Tab.Picture.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.Picture)input));
        } else if (input.i$(Dialog.Tab.Date.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.Date)input));
        } else if (input.i$(Dialog.Tab.DateTime.class)) {
            builder.add("input", (Object)this.frameOf((Dialog.Tab.DateTime)input));
        }
    }

    private Frame frameOf(Dialog.Tab.Memo memo) {
        FrameBuilder builder = new FrameBuilder(new String[]{"memo"});
        builder.add("mode", (Object)memo.mode().name());
        builder.add("height", (Object)memo.height());
        this.addCommon(builder, memo);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Password password) {
        FrameBuilder builder = new FrameBuilder(new String[]{"password"});
        if (password.validation() != null) {
            builder.add("validation", (Object)this.frameOf(password.validation()));
        }
        this.addCommon(builder, password);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Password.Validation validation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"password", "validation"});
        builder.add("required", validation.isRequired().stream().map(Enum::name).toArray(String[]::new));
        if (validation.length() != null) {
            builder.add("min", (Object)validation.length().min()).add("max", (Object)validation.length().max());
        }
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.ComboBox combo) {
        FrameBuilder builder = new FrameBuilder(new String[]{"combo"});
        this.addSources(combo, builder);
        this.addCommon(builder, combo);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.CheckBox check) {
        FrameBuilder builder = new FrameBuilder(new String[]{"check"});
        this.addSources(check, builder);
        this.addCommon(builder, check);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.RadioBox radio) {
        FrameBuilder builder = new FrameBuilder(new String[]{"radio"});
        this.addSources(radio, builder);
        this.addCommon(builder, radio);
        return builder.toFrame();
    }

    private void addSources(Dialog.Tab.OptionBox comboBox, FrameBuilder builder) {
        if (comboBox.source() != null && !comboBox.source().isEmpty()) {
            builder.add("source", (Object)this.sourceOf(comboBox));
        } else if (comboBox.options() != null && !comboBox.options().isEmpty()) {
            builder.add("options", (Object)comboBox.options().toArray(new String[0]));
        }
    }

    private Frame sourceOf(Dialog.Tab.OptionBox optionBox) {
        return new FrameBuilder().add("dialog", (Object)((Dialog)optionBox.core$().ownerAs(Dialog.class)).name$()).add("name", (Object)optionBox.source()).add("type", (Object)((Object)((Object)optionBox)).getClass().getSimpleName()).toFrame();
    }

    private Frame frameOf(Dialog.Tab.File file) {
        FrameBuilder builder = new FrameBuilder(new String[]{"file"});
        if (file.validation() != null) {
            builder.add("validation", (Object)this.frameOf(file.validation()));
        }
        this.addCommon(builder, file);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Picture picture) {
        FrameBuilder builder = new FrameBuilder(new String[]{"picture"});
        if (picture.validation() != null) {
            builder.add("validation", (Object)this.frameOf(picture.validation()));
        }
        this.addCommon(builder, picture);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Resource.Validation validation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"resource", "validation"});
        if (validation.maxSize() > 0.0) {
            builder.add("maxSize", (Object)validation.maxSize());
        }
        if (!validation.allowedExtensions().isEmpty()) {
            builder.add("allowedExtensions", validation.allowedExtensions());
        }
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.Date date) {
        FrameBuilder builder = new FrameBuilder(new String[]{"date"});
        builder.add("format", (Object)date.format());
        this.addCommon(builder, date);
        return builder.toFrame();
    }

    private Frame frameOf(Dialog.Tab.DateTime dateTime) {
        FrameBuilder builder = new FrameBuilder(new String[]{"dateTime"});
        builder.add("format", (Object)dateTime.format());
        this.addCommon(builder, dateTime);
        return builder.toFrame();
    }

    private void addCommon(FrameBuilder frame, Dialog.Tab.Input input) {
        frame.add("owner", (Object)input.core$().owner().name());
        if (input.name$() != null && !input.name$().isEmpty()) {
            frame.add("name", (Object)input.name$());
        }
        frame.add("label", (Object)input.label());
        frame.add("readonly", (Object)input.isReadonly());
        frame.add("required", (Object)input.isRequired());
        frame.add("placeholder", (Object)input.placeHolder());
        frame.add("defaultValue", (Object)input.defaultValue());
        if (input.i$(MultipleInput.class)) {
            MultipleInput multiple = input.asMultiple();
            frame.add("multiple", (Object)new FrameBuilder(new String[]{"multiple"}).add("min", (Object)multiple.min()).add("max", (Object)multiple.max()));
        }
        if (input.validator() != null && !input.validator().isEmpty()) {
            frame.add("validator", (Object)this.validator(input));
        }
    }

    private Frame validator(Dialog.Tab.Input input) {
        return new FrameBuilder(new String[]{"validator"}).add("dialog", (Object)((Dialog)input.core$().ownerAs(Dialog.class)).name$()).add("name", (Object)input.validator()).add("type", (Object)((Object)((Object)input)).getClass().getSimpleName()).toFrame();
    }

    private Template template() {
        return Formatters.customize(new AbstractDialogTemplate());
    }
}

