/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.slack;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.slack.BotActionsUpdater;
import io.intino.konos.builder.codegeneration.services.slack.SlackTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SlackRenderer {
    private final Project project;
    private final List<SlackBotService> services;
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public SlackRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.project = project;
        this.services = graph.slackBotServiceList();
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(SlackBotService service) {
        String srcName = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack";
        FrameBuilder builder = this.createFrameBuilder(service.name$(), service.requestList(), true);
        for (String level : this.collectLevels(service).keySet()) {
            builder.add("level", (Object)new FrameBuilder(new String[]{"level"}).add("name", (Object)level).toFrame());
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "SlackBot", this.template().render((Object)builder));
        if (this.alreadyRendered(new File(this.src, "slack"), srcName)) {
            this.updateBot(service, srcName);
        } else {
            this.newBotActions(service);
        }
    }

    private void updateBot(SlackBotService service, String name) {
        new BotActionsUpdater(this.project, Commons.javaFile(new File(this.src, "slack"), name), service.requestList(), this.boxName).update();
        VirtualFileManager.getInstance().asyncRefresh(null);
    }

    private void newBotActions(SlackBotService service) {
        File directory = new File(this.src, "slack");
        if (!this.alreadyRendered(directory, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack")) {
            Commons.writeFrame(directory, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack", this.template().render((Object)this.createFrameBuilder(service.name$(), service.requestList(), false)));
        }
        Map<String, List<SlackBotService.Request>> groups = this.collectLevels(service);
        for (String requestContainer : groups.keySet()) {
            this.classes.put("Service#" + service.name$(), "slack." + requestContainer + "Slack");
            if (this.alreadyRendered(directory, requestContainer + "Slack")) continue;
            Commons.writeFrame(directory, requestContainer + "Slack", this.template().render((Object)this.createFrameBuilder(requestContainer, groups.get(requestContainer), false)));
        }
    }

    private Map<String, List<SlackBotService.Request>> collectLevels(SlackBotService service) {
        return this.collect(service.requestList());
    }

    private LinkedHashMap<String, List<SlackBotService.Request>> collect(List<SlackBotService.Request> requests) {
        LinkedHashMap map = requests.stream().filter(request -> !request.requestList().isEmpty()).collect(Collectors.toMap(this::name, SlackBotService.Request::requestList, (a, b) -> b, LinkedHashMap::new));
        for (SlackBotService.Request request2 : requests) {
            map.putAll(this.collect(request2.requestList()));
        }
        return map;
    }

    private String name(SlackBotService.Request request) {
        String s;
        StringBuilder name = new StringBuilder();
        SlackBotService.Request r = request;
        while (r.i$(SlackBotService.Request.class)) {
            name.insert(0, Commons.firstUpperCase(r.name$()) + "|");
            if (!r.core$().owner().is(SlackBotService.Request.class)) break;
            r = (SlackBotService.Request)r.core$().ownerAs(SlackBotService.Request.class);
        }
        return (s = name.toString()).endsWith("|") ? s.substring(0, s.length() - 1) : s;
    }

    @NotNull
    private FrameBuilder createFrameBuilder(String name, List<SlackBotService.Request> requests, boolean gen) {
        FrameBuilder builder = new FrameBuilder(new String[]{"slack", gen ? "gen" : "actions"});
        builder.add("package", (Object)this.packageName).add("name", (Object)name).add("box", (Object)this.boxName);
        if (gen) {
            this.allRequests(requests, builder);
        } else {
            this.createRequests(requests, builder);
        }
        FrameBuilder frameBuilder = builder;
        if (frameBuilder == null) {
            SlackRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private void allRequests(List<SlackBotService.Request> requests, FrameBuilder builder) {
        for (SlackBotService.Request request : requests) {
            builder.add("request", (Object)this.createRequestFrame(request));
            this.allRequests(request.requestList(), builder);
        }
    }

    private void createRequests(List<SlackBotService.Request> requests, FrameBuilder builder) {
        for (SlackBotService.Request request : requests) {
            builder.add("request", (Object)this.createRequestFrame(request));
        }
    }

    private Frame createRequestFrame(SlackBotService.Request request) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("type", (Object)(request.core$().owner().is(SlackBotService.Request.class) ? this.name((SlackBotService.Request)request.core$().ownerAs(SlackBotService.Request.class)) : request.core$().owner().name())).add("box", (Object)this.boxName).add("name", (Object)request.name$()).add("description", (Object)request.description());
        if (request.core$().owner().is(SlackBotService.Request.class)) {
            builder.add("context", (Object)this.name((SlackBotService.Request)request.core$().ownerAs(SlackBotService.Request.class)));
        }
        builder.add("responseType", (Object)(request.responseType().equals((Object)SlackBotService.Request.ResponseType.Text) ? "String" : "SlackAttachment"));
        List<SlackBotService.Request.Parameter> parameters = request.parameterList();
        for (int i = 0; i < parameters.size(); ++i) {
            builder.add("parameter", (Object)new FrameBuilder(new String[]{"parameter", parameters.get(i).type().name(), parameters.get(i).multiple() ? "multiple" : "single"}).add("type", (Object)parameters.get(i).type().name()).add("name", (Object)parameters.get(i).name$()).add("pos", (Object)i).toFrame());
        }
        for (SlackBotService.Request component : request.requestList()) {
            builder.add("component", (Object)component.name$());
        }
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new SlackTemplate()).add("slashToCamelCase", o -> StringHelper.snakeCaseToCamelCase((String)o.toString().replace("|", "_")));
    }

    private boolean alreadyRendered(File destiny, String name) {
        return Commons.javaFile(destiny, name).exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/slack/SlackRenderer", "createFrameBuilder"));
    }
}

