/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jms;

import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.jms.JMSServiceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.jms.JMSService;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class JMSServiceRenderer {
    private final List<JMSService> services;
    private final String boxName;
    private File gen;
    private String packageName;

    public JMSServiceRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.services = graph.jMSServiceList();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(JMSService service) {
        Commons.writeFrame(this.gen, this.nameOf(service), this.template().render((Object)new FrameBuilder(new String[]{"jms"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("model", (Object)service.subscriptionModel().name()).add("request", (Object)this.processRequests(service.requestList(), service.subscriptionModel().name())).add("notification", (Object)this.processNotifications(service.notificationList(), service.subscriptionModel().name())).toFrame()));
    }

    @NotNull
    private String nameOf(JMSService service) {
        String string = ((Formatter)StringFormatters.get((Locale)Locale.getDefault()).get("firstuppercase")).format((Object)service.name$()).toString() + "Service";
        if (string == null) {
            JMSServiceRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    private Frame[] processRequests(List<JMSService.Request> requests, String subscriptionModel) {
        return (Frame[])requests.stream().map(request -> this.processRequest((JMSService.Request)((Object)request), subscriptionModel)).toArray(Frame[]::new);
    }

    private Frame processRequest(JMSService.Request request, String subscriptionModel) {
        return new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("model", (Object)subscriptionModel).add("queue", (Object)Formatters.customize("queue", request.path())).toFrame();
    }

    private Frame[] processNotifications(List<JMSService.Notification> notifications, String subscriptionModel) {
        return (Frame[])notifications.stream().map(notification -> this.processNotification((JMSService.Notification)((Object)notification), subscriptionModel)).toArray(Frame[]::new);
    }

    private Frame processNotification(JMSService.Notification notification, String subscriptionModel) {
        return new FrameBuilder(new String[]{"notification"}).add("name", (Object)notification.name$()).add("package", (Object)this.packageName).add("queue", (Object)Formatters.customize("queue", notification.path())).add("model", (Object)subscriptionModel).add("parameter", (Object)this.parameters(notification.parameterList())).add("returnMessageType", (Object)this.messageType(notification.parameterList())).toFrame();
    }

    private Template template() {
        return Formatters.customize(new JMSServiceTemplate());
    }

    private String messageType(List<Parameter> parameters) {
        return parameters.stream().anyMatch(Parameter::isFile) ? "Bytes" : "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/jms/JMSServiceRenderer", "nameOf"));
    }
}

