/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jms;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.JMSRequestActionRenderer;
import io.intino.konos.builder.codegeneration.services.jms.JMSRequestTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.jms.JMSService;
import java.io.File;
import java.util.List;
import java.util.Map;

public class JMSRequestRenderer {
    private static final String REQUESTS = "requests";
    private final Project project;
    private final List<JMSService> services;
    private final String boxName;
    private final Map<String, String> classes;
    private File gen;
    private File src;
    private String packageName;

    public JMSRequestRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.project = project;
        this.services = graph.jMSServiceList();
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(JMSService service) {
        service.core$().findNode(JMSService.Request.class).forEach(this::processRequest);
    }

    private void processRequest(JMSService.Request resource) {
        Commons.writeFrame(new File(this.gen, REQUESTS), StringHelper.snakeCaseToCamelCase((String)resource.name$()) + "Request", this.template().render((Object)this.fillRequestFrame(resource)));
        this.createCorrespondingAction(resource);
    }

    private void createCorrespondingAction(JMSService.Request request) {
        new JMSRequestActionRenderer(this.project, request, this.src, this.packageName, this.boxName, this.classes).execute();
    }

    private Frame fillRequestFrame(JMSService.Request request) {
        String returnType = Commons.returnType(request.response());
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("call", (Object)new FrameBuilder(new String[]{returnType}).toFrame()).add("parameter", (Object)this.parameters(request.parameterList()));
        if (!returnType.equals("void")) {
            builder.add("returnType", (Object)returnType).add("returnMessageType", (Object)this.messageType(request.response()));
        }
        if (!request.exceptionList().isEmpty() || !request.exceptionRefs().isEmpty()) {
            builder.add("exception", (Object)"");
        }
        if (!request.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName).toFrame());
        }
        return builder.toFrame();
    }

    private String messageType(Response response) {
        return response.isFile() ? "Bytes" : "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()});
        if (parameter.isList()) {
            builder.add("List");
        }
        return builder.add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private Template template() {
        return Formatters.customize(new JMSRequestTemplate());
    }
}

