/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.mounter;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.population.PopulationMounter;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MounterRenderer {
    private final List<Mounter> mounters;
    private final File gen;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;
    private final File sourceMounters;
    private File genMounters;

    public MounterRenderer(KonosGraph graph, File gen, File src, String packageName, String boxName, Map<String, String> classes) {
        this.mounters = graph.dataHub().mounterList();
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
        this.sourceMounters = new File(src, "datahub/mounters");
        this.genMounters = new File(gen, "datahub/mounters");
    }

    public void execute() {
        for (Mounter mounter : this.mounters) {
            String mounterName = mounter.name$();
            FrameBuilder builder = new FrameBuilder(new String[]{"mounter"}).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("name", (Object)mounter.name$());
            if (mounter.isPopulation()) {
                this.populationMounter(mounter, mounterName, builder);
                continue;
            }
            if (mounter.isRealtime() && !this.alreadyRendered(this.sourceMounters, mounterName)) {
                this.realtimeMounter(mounter, mounterName, builder);
                continue;
            }
            if (mounter.isRealtime() || this.alreadyRendered(this.sourceMounters, mounterName)) continue;
            this.batchMounter(mounter, mounterName, builder);
        }
    }

    private void realtimeMounter(Mounter mounter, String mounterName, FrameBuilder builder) {
        this.realtimeMounter(builder, mounter);
        this.classes.put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "datahub.mounters." + mounterName);
        Commons.writeFrame(this.sourceMounters, mounterName, Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
    }

    private void batchMounter(Mounter mounter, String mounterName, FrameBuilder builder) {
        Commons.writeFrame(new File(this.src, "datahub/mounters"), mounterName, Formatters.customize(new MounterTemplate()).render((Object)builder.add("batch").toFrame()));
        this.classes.put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "datahub.mounters." + mounterName);
    }

    private void populationMounter(Mounter mounter, String mounterName, FrameBuilder builder) {
        this.populationMounter(builder, mounter.asPopulation());
        this.classes.put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "datahub.mounters." + mounterName);
        Commons.writeFrame(this.genMounters, mounter.name$(), Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
        if (!this.alreadyRendered(this.sourceMounters, mounter.name$() + "MounterFunctions")) {
            Commons.writeFrame(this.sourceMounters, mounter.name$() + "MounterFunctions", Formatters.customize(new MounterTemplate()).render((Object)builder.add("src").toFrame()));
        }
    }

    private void populationMounter(FrameBuilder builder, PopulationMounter mounter) {
        List<PopulationMounter.Column> splittedColumns = mounter.columnList().stream().filter(c -> c.tank().split() != null).collect(Collectors.toList());
        if (!splittedColumns.isEmpty()) {
            builder.add("population").add("splittedColumns", (Object)this.splitted(splittedColumns));
        }
        builder.add("column", mounter.columnList().stream().map(column -> this.builderOf((PopulationMounter.Column)((Object)column)).toFrame()).toArray(Frame[]::new));
        builder.add("datamart", (Object)mounter.collect().datamart().name$());
        builder.add("format", (Object)mounter.collect().format().name());
    }

    private Frame splitted(List<PopulationMounter.Column> splittedColumns) {
        return new FrameBuilder(new String[]{"splittedColumns"}).add("column", splittedColumns.stream().map(column -> this.builderOf((PopulationMounter.Column)((Object)column)).add("splitted").toFrame()).toArray(Frame[]::new)).toFrame();
    }

    private FrameBuilder builderOf(PopulationMounter.Column column) {
        FrameBuilder builder = new FrameBuilder(new String[]{"column"}).add("fullName", (Object)column.tank().fullName()).add("name", (Object)column.tank().name$()).add("type", (Object)column.type().name()).add("mounter", (Object)((Mounter)column.core$().ownerAs(Mounter.class)).name$());
        if (column.isId()) {
            builder.add("facet", (Object)"id");
        }
        return builder;
    }

    private void realtimeMounter(FrameBuilder builder, Mounter mounter) {
        builder.add("realtime");
        if (mounter.asRealtime().selectList().size() == 1) {
            Schema schema = mounter.asRealtime().select(0).tank().asEvent().schema();
            if (schema != null) {
                builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
                builder.add("type", (Object)new FrameBuilder(new String[]{"schema"}).add("package", (Object)this.packageName).add("name", (Object)schema.name$()));
            } else {
                builder.add("type", (Object)"message");
            }
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

