/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UIActionRenderer
extends ActionRenderer {
    private final AbstractUIService.Resource resource;
    private final File gen;
    private final UIService service;
    private final Map<String, String> classes;

    public UIActionRenderer(Project project, AbstractUIService.Resource resource, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        super(project, src, packageName, boxName, "ui");
        this.gen = gen;
        this.resource = resource;
        this.service = (UIService)resource.core$().ownerAs(UIService.class);
        this.classes = classes;
    }

    public void execute() {
        FrameBuilder builder = new FrameBuilder(new String[]{"action", "ui"});
        builder.add("name", (Object)this.resource.name$());
        builder.add("uiService", (Object)((UIService)this.resource.core$().ownerAs(UIService.class)).name$());
        builder.add("package", (Object)this.packageName);
        builder.add("box", (Object)this.boxName);
        builder.add("type", (Object)(this.resource.isEditorPage() ? "Editor" : "Resource"));
        builder.add("importDialogs", (Object)this.packageName);
        builder.add("importDisplays", (Object)this.packageName);
        if (this.resource.isEditorPage()) {
            builder.add("editor", (Object)new FrameBuilder(new String[]{"editor"}));
        }
        builder.add("component", (Object)this.componentFrame());
        builder.add("parameter", (Object)this.parameters());
        this.service.useList().stream().map(use -> builder.add("usedAppUrl", (Object)new FrameBuilder(new String[]{"usedAppUrl", this.isCustom(use.url()) ? "custom" : "standard"}).add("value", (Object)(this.isCustom(use.url()) ? this.customValue(use.url()) : use.url())))).collect(Collectors.toList());
        if (this.service.favicon() != null) {
            builder.add("favicon", (Object)this.service.favicon());
        } else if (this.service.title() != null) {
            builder.add("title", (Object)this.service.title());
        }
        this.classes.put(((Object)((Object)this.resource)).getClass().getSimpleName() + "#" + this.firstUpperCase(this.resource.core$().name()), "actions." + this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)this.resource.name$())) + "Action");
        if (!this.alreadyRendered(this.destiny, this.resource.name$())) {
            Commons.writeFrame(this.destinyPackage(this.destiny), this.resource.name$() + "Action", this.template().render((Object)builder));
        }
        Commons.writeFrame(this.destinyPackage(this.gen), "Abstract" + this.firstUpperCase(this.resource.name$()) + "Action", this.template().render((Object)builder.add("gen")));
    }

    private Frame componentFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"component"}).add("value", (Object)KonosGraph.componentFor(this.resource).name$());
        if (this.resource.isEditorPage()) {
            Component display = this.resource.asEditorPage().editor().display();
            result.add("editor", (Object)new FrameBuilder(new String[]{"editor"}).add("display", (Object)display.name$()).toFrame());
        }
        return result.toFrame();
    }

    private Frame[] parameters() {
        List<String> parameters = Commons.extractUrlPathParameters(this.resource.path());
        return (Frame[])parameters.stream().map(parameter -> new FrameBuilder(new String[]{"parameter"}).add("type", (Object)"String").add("name", parameter).toFrame()).toArray(Frame[]::new);
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private String customValue(String value) {
        return value != null ? value.substring(1, value.length() - 1) : "";
    }
}

