/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.ArtifactTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.UIAccessorRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.plugin.dependencyresolution.DependencyCatalog;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import io.intino.tara.plugin.project.configuration.ConfigurationManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UIAccessorCreator {
    private static final String ARTIFACT_LEGIO = "artifact.legio";
    private final Project project;
    private final Module javaModule;
    private final List<UIService> serviceList;
    private String parent;

    public UIAccessorCreator(Module module, KonosGraph graph, String parent) {
        this.project = module == null ? null : module.getProject();
        this.javaModule = module;
        this.serviceList = graph.uIServiceList();
        this.parent = parent;
    }

    public void execute() {
        if (this.javaModule == null) {
            return;
        }
        for (UIService service : this.serviceList) {
            new UIAccessorRenderer(this.javaModule, this.getOrCreateModule(service), service, this.parent).execute();
        }
    }

    private Module getOrCreateModule(UIService service) {
        Module m = this.findModule(service.name$());
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> {
            if (m != null) {
                this.addWebDependency(TaraUtil.configurationOf((Module)m));
                return;
            }
            ModuleManager manager = ModuleManager.getInstance((Project)this.project);
            Module webModule = manager.newModule(this.modulePath(service), "WEB_MODULE");
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)webModule).getModifiableModel();
            File moduleRoot = new File(webModule.getModuleFilePath()).getParentFile();
            moduleRoot.mkdirs();
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)moduleRoot, (boolean)true);
            ContentEntry contentEntry = vFile != null ? model.addContentEntry(vFile) : model.addContentEntry(moduleRoot.getAbsolutePath());
            this.addExcludeFiles(moduleRoot, contentEntry);
            model.commit();
            boolean created = this.createConfigurationFile(moduleRoot, service.name$());
            if (created) {
                this.addWebDependency(ConfigurationManager.register((Module)webModule, (Configuration)ConfigurationManager.newExternalProvider((Module)webModule)));
            }
        }));
        return this.findModule(service.name$());
    }

    private boolean createConfigurationFile(File moduleRoot, String name) {
        Configuration configuration = TaraUtil.configurationOf((Module)this.javaModule);
        FrameBuilder builder = new FrameBuilder(new String[]{"artifact", "legio"});
        builder.add("groupId", (Object)configuration.groupId());
        builder.add("artifactId", (Object)Formatters.camelCaseToSnakeCase().format((Object)name).toString());
        builder.add("version", (Object)configuration.version());
        Map<String, List<String>> repositories = this.reduce(configuration.releaseRepositories());
        for (String id : repositories.keySet()) {
            FrameBuilder repoFrameBuilder = new FrameBuilder(new String[]{"repository", "release"}).add("id", (Object)id);
            for (String url : repositories.get(id)) {
                repoFrameBuilder.add("url", (Object)url);
            }
            builder.add("repository", (Object)repoFrameBuilder);
        }
        File file = new File(moduleRoot, ARTIFACT_LEGIO);
        if (!file.exists()) {
            Commons.write(file.toPath(), new ArtifactTemplate().render(builder));
            return true;
        }
        return false;
    }

    private Map<String, List<String>> reduce(Map<String, String> map) {
        HashMap<String, List<String>> reduced = new HashMap<String, List<String>>();
        map.forEach((key, value) -> {
            reduced.putIfAbsent((String)value, new ArrayList());
            ((List)reduced.get(value)).add(key);
        });
        return reduced;
    }

    private void addWebDependency(Configuration webConf) {
        ((LegioConfiguration)TaraUtil.configurationOf((Module)this.javaModule)).addDependency(DependencyCatalog.DependencyScope.WEB, webConf.groupId() + ":" + webConf.artifactId() + ":" + webConf.version());
    }

    private Module findModule(String name) {
        return (Module)ApplicationManager.getApplication().runReadAction(() -> Arrays.stream(ModuleManager.getInstance((Project)this.project).getModules()).filter(m -> m.getName().equals(this.toSnakeCase(name))).findFirst().orElse(null));
    }

    private void addExcludeFiles(File parent, ContentEntry contentEntry) {
        File lib = new File(parent, "lib");
        lib.mkdirs();
        contentEntry.addExcludeFolder(Objects.requireNonNull(VfsUtil.findFileByIoFile((File)lib, (boolean)true)));
    }

    private String toSnakeCase(String name) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1-$2";
        return name.replaceAll(regex, replacement).toLowerCase();
    }

    @NotNull
    private String modulePath(UIService service) {
        String string = this.project.getBasePath() + File.separator + this.toSnakeCase(service.name$()) + File.separator + this.toSnakeCase(service.name$()) + ".iml";
        if (string == null) {
            UIAccessorCreator.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/accessor/ui/UIAccessorCreator", "modulePath"));
    }
}

